/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.dom.html;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IHasChangeListener;
import to.etc.domui.dom.html.IValueChanged;
import to.etc.domui.dom.html.RadioButton;

public class RadioGroup<T>
extends Div
implements IHasChangeListener {
    private static int m_gidCounter;
    private String m_groupName;
    private List<RadioButton<T>> m_buttonList = new ArrayList<RadioButton<T>>();
    private T m_value;
    private IValueChanged<?> m_onValueChanged;
    private boolean m_immediate;

    public RadioGroup() {
        this.m_groupName = "g" + RadioGroup.nextID();
    }

    private static synchronized int nextID() {
        return ++m_gidCounter;
    }

    void addButton(RadioButton<T> b) {
        this.m_buttonList.add(b);
        b.setChecked(MetaManager.areObjectsEqual(this.m_value, b.getButtonValue()));
    }

    void removeButton(RadioButton<T> b) {
        this.m_buttonList.remove(b);
    }

    public String getName() {
        return this.m_groupName;
    }

    public T getValue() {
        return this.m_value;
    }

    public void setValue(T value) {
        if (MetaManager.areObjectsEqual(value, this.m_value)) {
            return;
        }
        this.m_value = value;
        for (RadioButton<T> rb : this.getButtonList()) {
            rb.setChecked(MetaManager.areObjectsEqual(value, rb.getButtonValue()));
        }
    }

    void internalSetValue(T newval) {
        this.m_value = newval;
    }

    public List<RadioButton<T>> getButtonList() {
        return Collections.unmodifiableList(this.m_buttonList);
    }

    @Override
    public IValueChanged<?> getOnValueChanged() {
        IValueChanged<?> vc = this.m_onValueChanged;
        if (null == vc && this.isImmediate()) {
            return IValueChanged.DUMMY;
        }
        return vc;
    }

    @Override
    public void setOnValueChanged(IValueChanged<?> onValueChanged) {
        this.m_onValueChanged = onValueChanged;
    }

    public boolean isImmediate() {
        return this.m_immediate;
    }

    public void immediate(boolean immediate) {
        this.m_immediate = immediate;
    }

    public void immediate() {
        this.m_immediate = true;
    }
}

