/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.dom.html;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.buttons.SmallImgButton;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.IHasModifiedIndication;
import to.etc.domui.dom.html.IHtmlInput;
import to.etc.domui.dom.html.INativeChangeListener;
import to.etc.domui.dom.html.INodeVisitor;
import to.etc.domui.dom.html.IReturnPressed;
import to.etc.domui.dom.html.InputNodeContainer;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.Page;
import to.etc.domui.dom.html.SelectOption;
import to.etc.domui.server.RequestContextImpl;
import to.etc.domui.util.DomUtil;

public class Select
extends InputNodeContainer
implements INativeChangeListener,
IHasModifiedIndication,
IHtmlInput {
    private boolean m_multiple;
    private boolean m_disabled;
    private int m_size;
    private int m_selectedIndex;
    private IReturnPressed<Select> m_returnPressed;
    private boolean m_modifiedByUser;
    private List<SmallImgButton> m_buttonList = Collections.EMPTY_LIST;

    public Select() {
        super("select");
    }

    public Select(String ... txt) {
        this();
        for (String s : txt) {
            this.add(new SelectOption(s));
        }
    }

    @Override
    public void visit(INodeVisitor v) throws Exception {
        v.visitSelect(this);
    }

    @Override
    protected void canContain(@Nonnull NodeBase node) {
        if (!(node instanceof SelectOption)) {
            throw new IllegalStateException(this.getClass().getName() + " cannot contain a " + node + " type, only a SelectOption node type.");
        }
    }

    public boolean isMultiple() {
        return this.m_multiple;
    }

    public void setMultiple(boolean multiple) {
        if (this.m_multiple == multiple) {
            return;
        }
        this.m_multiple = multiple;
        this.changed();
    }

    @Override
    public boolean isDisabled() {
        return this.m_disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        if (this.m_disabled == disabled) {
            return;
        }
        this.m_disabled = disabled;
        if (disabled) {
            this.addCssClass("ui-ro");
        } else {
            this.removeCssClass("ui-ro");
        }
        this.changed();
    }

    public void setDisabled(@Nullable UIMessage rsn) {
        if (null != rsn) {
            this.setDisabled(true);
            this.setTitle(rsn.getMessage());
        } else {
            this.setDisabled(false);
            this.setTitle(null);
        }
    }

    public int getSize() {
        return this.m_size;
    }

    public void setSize(int size) {
        if (this.m_size == size) {
            return;
        }
        this.m_size = size;
        this.changed();
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.setDisabled(readOnly);
        super.setReadOnly(readOnly);
    }

    public SelectOption getOption(int ix) {
        if (ix < 0 || ix >= this.getChildCount()) {
            throw new ArrayIndexOutOfBoundsException("The option index " + ix + " is invalid, the #options is " + this.getChildCount());
        }
        return (SelectOption)this.getChild(ix);
    }

    @Override
    public final boolean acceptRequestParameter(@Nonnull String[] values) throws Exception {
        String in = values[0];
        SelectOption selo = (SelectOption)this.getPage().findNodeByID(in);
        int nindex = selo == null ? -1 : this.findChildIndex(selo);
        int oldindex = this.m_selectedIndex;
        this.setSelectedIndex(nindex);
        if (!this.internalOnUserInput(oldindex, nindex)) {
            return false;
        }
        DomUtil.setModifiedFlag(this);
        return true;
    }

    protected boolean internalOnUserInput(int oldindex, int nindex) {
        return oldindex != nindex;
    }

    @Deprecated
    public void clearSelected() {
        this.m_selectedIndex = -1;
        int i = this.getChildCount();
        while (--i >= 0) {
            this.getOption(i).setSelected(false);
        }
    }

    public int getSelectedIndex() {
        return this.m_selectedIndex;
    }

    public void internalSetSelectedIndex(int ix) {
        this.m_selectedIndex = ix;
    }

    public void setSelectedIndex(int ix) {
        this.m_selectedIndex = ix;
        int i = this.getChildCount();
        while (--i >= 0) {
            this.getOption(i).setSelected(i == this.m_selectedIndex);
        }
    }

    public void addExtraButton(String img, String title, final IClicked<NodeBase> click) {
        if (this.m_buttonList == Collections.EMPTY_LIST) {
            this.m_buttonList = new ArrayList<SmallImgButton>();
        }
        SmallImgButton si = new SmallImgButton(img);
        if (click != null) {
            si.setClicked(new IClicked<SmallImgButton>(){

                @Override
                public void clicked(@Nonnull SmallImgButton b) throws Exception {
                    click.clicked(Select.this);
                }
            });
        }
        if (title != null) {
            si.setTitle(title);
        }
        si.addCssClass("ui-cl2-btn");
        this.m_buttonList.add(si);
        if (this.isBuilt()) {
            this.forceRebuild();
        }
    }

    @Override
    public void onAddedToPage(Page p) {
        NodeContainer curr = this;
        for (SmallImgButton sib : this.m_buttonList) {
            curr.appendAfterMe(sib);
            curr = sib;
        }
    }

    @Override
    public void onRemoveFromPage(Page p) {
        for (SmallImgButton sib : this.m_buttonList) {
            sib.remove();
        }
    }

    @Override
    public final boolean isModified() {
        return this.m_modifiedByUser;
    }

    @Override
    public final void setModified(boolean as) {
        this.m_modifiedByUser = as;
    }

    public IReturnPressed<Select> getReturnPressed() {
        return this.m_returnPressed;
    }

    public void setReturnPressed(IReturnPressed<Select> returnPressed) {
        this.m_returnPressed = returnPressed;
    }

    @Override
    public void componentHandleWebAction(@Nonnull RequestContextImpl ctx, @Nonnull String action) throws Exception {
        if (!"returnpressed".equals(action)) {
            super.componentHandleWebAction(ctx, action);
            return;
        }
        if (this.m_returnPressed != null) {
            this.m_returnPressed.returnPressed(this);
        }
    }
}

