/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.dom.html;

import to.etc.domui.dom.html.INodeVisitor;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.TH;
import to.etc.domui.dom.html.TR;
import to.etc.webapp.nls.BundleRef;

public class THead
extends NodeContainer {
    public THead() {
        super("thead");
    }

    @Override
    public void visit(INodeVisitor v) throws Exception {
        v.visitTHead(this);
    }

    public TH[] setHeaders(String ... labels) {
        this.forceRebuild();
        TR row = new TR();
        this.add(row);
        TH[] res = new TH[labels.length];
        int ix = 0;
        for (String s : labels) {
            TH th = new TH();
            row.add(th);
            th.setText(s);
            res[ix++] = th;
        }
        return res;
    }

    public TH[] setHeaders(BundleRef b, String ... keys) {
        this.forceRebuild();
        TR row = new TR();
        this.add(row);
        TH[] res = new TH[keys.length];
        int ix = 0;
        for (String s : keys) {
            TH th = new TH();
            row.add(th);
            th.setText(b.getString(s));
            res[ix++] = th;
        }
        return res;
    }

    public void setHeaderCssClasses(String cls) {
        for (TH th : this.getChildren(TH.class)) {
            th.setCssClass(cls);
        }
    }

    private TR getRow() {
        int i = this.getChildCount();
        while (--i >= 0) {
            NodeBase b = this.getChild(i);
            if (!(b instanceof TR)) continue;
            return (TR)b;
        }
        TR tr = new TR();
        this.add(tr);
        return tr;
    }

    public TH addHeader(String text) {
        TR tr = this.getRow();
        TH th = new TH();
        tr.add(th);
        th.setText(text);
        return th;
    }

    public TH addHeader(NodeBase node) {
        TR tr = this.getRow();
        TH th = new TH();
        tr.add(th);
        th.add(node);
        return th;
    }
}

