/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.dom.html;

import javax.annotation.Nonnull;
import to.etc.domui.dom.html.INodeVisitor;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.TH;
import to.etc.domui.dom.html.THead;
import to.etc.domui.dom.html.TR;
import to.etc.domui.dom.html.TableAlignType;
import to.etc.domui.dom.html.TextNode;
import to.etc.domui.dom.html.XmlTextNode;
import to.etc.domui.util.DomUtil;

public class Table
extends NodeContainer {
    private String m_cellPadding;
    private String m_cellSpacing;
    private String m_tableWidth;
    private String m_tableHeight;
    private int m_tableBorder = -1;
    private TableAlignType m_align;

    public Table() {
        super("table");
    }

    @Override
    public void visit(INodeVisitor v) throws Exception {
        v.visitTable(this);
    }

    public String getCellPadding() {
        return this.m_cellPadding;
    }

    public void setCellPadding(String cellPadding) {
        if (DomUtil.isEqual((Object)cellPadding, (Object)this.m_cellPadding)) {
            return;
        }
        this.changed();
        this.m_cellPadding = cellPadding;
    }

    public String getCellSpacing() {
        return this.m_cellSpacing;
    }

    public void setCellSpacing(String cellSpacing) {
        if (DomUtil.isEqual((Object)cellSpacing, (Object)this.m_cellSpacing)) {
            return;
        }
        this.changed();
        this.m_cellSpacing = cellSpacing;
    }

    public String getTableWidth() {
        return this.m_tableWidth;
    }

    public void setTableWidth(String tableWidth) {
        if (!DomUtil.isEqual((Object)tableWidth, (Object)this.m_tableWidth)) {
            this.changed();
        }
        this.m_tableWidth = tableWidth;
    }

    public int getTableBorder() {
        return this.m_tableBorder;
    }

    public void setTableBorder(int tableBorder) {
        if (tableBorder != this.m_tableBorder) {
            this.changed();
        }
        this.m_tableBorder = tableBorder;
    }

    public void setTableHead(String ... labels) {
        THead h = this.getHead();
        h.forceRebuild();
        TR row = new TR();
        h.add(row);
        for (String s : labels) {
            TH th = new TH();
            row.add(th);
            th.setText(s);
        }
    }

    public TH addHeader(NodeBase header) {
        THead h = this.getHead();
        return h.addHeader(header);
    }

    public TH addHeader(String text) {
        THead h = this.getHead();
        return h.addHeader(text);
    }

    @Override
    protected void canContain(@Nonnull NodeBase node) {
        if (node instanceof XmlTextNode) {
            return;
        }
        if (node instanceof TextNode) {
            throw new IllegalStateException("Dont be silly- cannot add text to a table");
        }
        if (node instanceof TR) {
            throw new IllegalStateException("Add TR's to the TBody, not the Table");
        }
        if (!(node instanceof TBody) && !(node instanceof THead)) {
            throw new IllegalStateException("Dont be silly- should not add a " + node.getTag() + " to a table");
        }
        super.canContain(node);
    }

    public TBody getBody() {
        int i = this.getChildCount();
        while (--i >= 0) {
            NodeBase n = this.getChild(i);
            if (!(n instanceof TBody)) continue;
            return (TBody)n;
        }
        TBody b = new TBody();
        super.add(b);
        return b;
    }

    public THead getHead() {
        int i = this.getChildCount();
        while (--i >= 0) {
            NodeBase n = this.getChild(i);
            if (!(n instanceof THead)) continue;
            return (THead)n;
        }
        THead b = new THead();
        super.add(b);
        return b;
    }

    public TBody addBody() {
        TBody b = new TBody();
        this.add(b);
        return b;
    }

    public String getTableHeight() {
        return this.m_tableHeight;
    }

    public void setTableHeight(String tableHeight) {
        if (DomUtil.isEqual((Object)tableHeight, (Object)this.m_tableHeight)) {
            return;
        }
        this.m_tableHeight = tableHeight;
        this.changed();
    }

    public TableAlignType getAlign() {
        return this.m_align;
    }

    public void setAlign(TableAlignType align) {
        if (this.m_align == align) {
            return;
        }
        this.m_align = align;
        this.changed();
    }
}

