/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.dom.html;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.MetaUtils;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.IHasModifiedIndication;
import to.etc.domui.dom.html.IHtmlInput;
import to.etc.domui.dom.html.INativeChangeListener;
import to.etc.domui.dom.html.INodeVisitor;
import to.etc.domui.dom.html.InputNodeContainer;
import to.etc.domui.server.DomApplication;
import to.etc.domui.trouble.ValidationException;
import to.etc.domui.util.DomUtil;
import to.etc.util.StringTool;

public class TextArea
extends InputNodeContainer
implements INativeChangeListener,
IControl<String>,
IHasModifiedIndication,
IHtmlInput {
    public static final String HINT = "textarea";
    private int m_cols = -1;
    private int m_rows = -1;
    private String m_value;
    private boolean m_disabled;
    private boolean m_modifiedByUser;
    private int m_maxLength;
    private int m_maxByteLength;
    @Nullable
    private String m_disabledBecause;

    public TextArea() {
        super(HINT);
    }

    public TextArea(int cols, int rows) {
        this();
        this.m_cols = cols;
        this.m_rows = rows;
    }

    @Override
    public void visit(INodeVisitor v) throws Exception {
        v.visitTextArea(this);
    }

    public int getCols() {
        return this.m_cols;
    }

    public void setCols(int cols) {
        if (this.m_cols == cols) {
            return;
        }
        this.changed();
        this.m_cols = cols;
    }

    public int getRows() {
        return this.m_rows;
    }

    public void setRows(int rows) {
        if (this.m_rows == rows) {
            return;
        }
        this.changed();
        this.m_rows = rows;
    }

    @Nullable
    public String getBindValue() {
        this.validate();
        return this.m_value;
    }

    public void setBindValue(@Nullable String value) {
        if (MetaManager.areObjectsEqual(this.m_value, value)) {
            return;
        }
        this.setValue(value);
    }

    private void validate() {
        if (StringTool.isBlank((String)this.m_value) && this.isMandatory()) {
            throw new ValidationException("ui.mandatory", new Object[0]);
        }
    }

    @Override
    public String getValue() {
        try {
            this.validate();
            return this.m_value;
        }
        catch (ValidationException x) {
            this.setMessage(UIMessage.error(x));
            throw x;
        }
    }

    @Override
    public String getValueSafe() {
        return DomUtil.getValueSafe(this);
    }

    @Override
    public boolean hasError() {
        this.getValueSafe();
        return super.hasError();
    }

    public String getRawValue() {
        return this.m_value;
    }

    @Override
    public boolean isDisabled() {
        return this.m_disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        if (this.m_disabled == disabled) {
            return;
        }
        this.changed();
        this.m_disabled = disabled;
        if (!disabled) {
            this.setOverrideTitle(null);
        }
    }

    @Nullable
    public String getDisabledBecause() {
        return this.m_disabledBecause;
    }

    public void setDisabledBecause(@Nullable String msg) {
        if (Objects.equals(msg, this.m_disabledBecause)) {
            return;
        }
        this.m_disabledBecause = msg;
        this.setOverrideTitle(msg);
        this.setDisabled(msg != null);
    }

    @Override
    public void setValue(@Nullable String v) {
        String value = this.m_value;
        if (DomUtil.isEqual((Object)v, (Object)value)) {
            return;
        }
        this.m_value = v;
        this.setMessage(null);
        this.setText(v);
    }

    @Override
    public boolean acceptRequestParameter(@Nonnull String[] values) throws Exception {
        int maxBytes;
        int maxLength;
        String flattenLineBreaksNw;
        String cur;
        String nw;
        String string = nw = values == null || values.length != 1 ? null : values[0];
        if (nw != null && nw.length() == 0) {
            nw = null;
        }
        String string2 = cur = this.m_value != null && this.m_value.length() == 0 ? null : this.m_value;
        if (cur != null) {
            cur = cur.replaceAll("\r\n", "\n");
        }
        String string3 = flattenLineBreaksNw = nw != null ? nw.replaceAll("\r\n", "\n") : null;
        if (flattenLineBreaksNw != null && cur != null && cur.startsWith("\n") && !flattenLineBreaksNw.startsWith("\n")) {
            cur = cur.substring(1);
        }
        if ((maxLength = this.getMaxLength()) > 0 && nw != null && nw.length() > maxLength) {
            nw = nw.substring(0, maxLength);
        }
        if ((maxBytes = this.getMaxByteLength()) > 0) {
            if (maxLength <= 0) {
                maxLength = maxBytes;
            }
            nw = StringTool.strTruncateUtf8Bytes((String)nw, (int)maxLength, (int)maxBytes);
        }
        if (DomUtil.isEqual((Object)flattenLineBreaksNw, (Object)cur)) {
            return false;
        }
        this.setValue(nw);
        DomUtil.setModifiedFlag(this);
        return true;
    }

    @Override
    public boolean isModified() {
        return this.m_modifiedByUser;
    }

    @Override
    public void setModified(boolean as) {
        this.m_modifiedByUser = as;
    }

    @Nonnull
    public static TextArea create(@Nonnull PropertyMetaModel<?> pmm) {
        int maxlen;
        String s;
        TextArea ta = new TextArea();
        String cth = pmm.getComponentTypeHint();
        if (cth != null) {
            String hint = cth.toLowerCase();
            ta.setCols(MetaUtils.parseIntParam(hint, "col", 80));
            ta.setRows(MetaUtils.parseIntParam(hint, "row", 4));
        }
        if (pmm.isRequired()) {
            ta.setMandatory(true);
        }
        if ((s = pmm.getDefaultHint()) != null) {
            ta.setTitle(s);
        }
        if ((maxlen = pmm.getLength()) > 0) {
            ta.setMaxLength(maxlen);
            ta.setMaxByteLength(DomApplication.getPlatformVarcharByteLimit());
        }
        return ta;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        if (readOnly == this.isReadOnly()) {
            return;
        }
        super.setReadOnly(readOnly);
        if (this.isReadOnly()) {
            this.addCssClass("ui-textarea-ro");
        } else {
            this.removeCssClass("ui-textarea-ro");
        }
    }

    public int getMaxLength() {
        return this.m_maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.m_maxLength = maxLength;
    }

    public int getMaxByteLength() {
        return this.m_maxByteLength;
    }

    public void setMaxByteLength(int maxByteLength) {
        this.m_maxByteLength = maxByteLength;
    }
}

