/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.dom.html;

import javax.annotation.DefaultNonNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.INotifyPageEvent;
import to.etc.domui.logic.ILogicContext;
import to.etc.domui.logic.LogicContextImpl;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.IRequestContext;
import to.etc.domui.server.RequestContextImpl;
import to.etc.domui.themes.DefaultThemeVariant;
import to.etc.domui.themes.IThemeVariant;
import to.etc.webapp.query.IQContextContainer;
import to.etc.webapp.query.QContextContainer;
import to.etc.webapp.query.QContextManager;
import to.etc.webapp.query.QDataContext;
import to.etc.webapp.query.QDataContextFactory;

@DefaultNonNull
public class UrlPage
extends Div {
    @Nullable
    private String m_pageTitle;
    @Nullable
    private INotifyPageEvent m_notifyPageEvent;
    private IThemeVariant m_themeVariant = DefaultThemeVariant.INSTANCE;

    public UrlPage() {
        this.setCssClass("ui-content ui-kludge");
    }

    public final void setThemeVariant(@Nonnull IThemeVariant themeVariant) {
        this.m_themeVariant = themeVariant;
    }

    public final IThemeVariant getThemeVariant() {
        return this.m_themeVariant;
    }

    @Deprecated
    public void unkludge() {
        this.removeCssClass("ui-content");
        this.removeCssClass("ui-kludge");
    }

    public void onReload() throws Exception {
    }

    public void onDestroy() throws Exception {
    }

    @Nullable
    public String getPageTitle() {
        return this.m_pageTitle;
    }

    @Override
    @Nonnull
    public String getTestRepeatId() {
        return "";
    }

    public void setPageTitle(@Nullable String pageTitle) {
        this.m_pageTitle = pageTitle;
    }

    public void closeWindow() {
        this.appendJavascript("window.close();");
    }

    protected void fixStretchBody() {
        this.appendCreateJS("$(document).ready(function() {$('body').addClass('ui-stretch-body');$('html').height('100%'); " + UrlPage.getCustomUpdatesCallJS() + "});");
    }

    protected void fixStretchBodyUnkludged() {
        this.appendCreateJS("$(document).ready(function() {$('html').height('100%');$('body').height('100%');" + UrlPage.getCustomUpdatesCallJS() + "});");
    }

    @Override
    @Nonnull
    public QDataContext getSharedContext() throws Exception {
        return this.getSharedContext("default-context");
    }

    @Nonnull
    public QDataContext getSharedContext(@Nonnull String key) throws Exception {
        return QContextManager.getContext((String)key, (QContextContainer)this.getPage().getContextContainer(key));
    }

    @Override
    @Nonnull
    public QDataContextFactory getSharedContextFactory() {
        return this.getSharedContextFactory("default-context");
    }

    @Nonnull
    public QDataContextFactory getSharedContextFactory(@Nonnull String key) {
        return QContextManager.getDataContextFactory((String)key, (QContextContainer)this.getPage().getContextContainer(key));
    }

    @Override
    protected void onForceRebuild() {
        super.onForceRebuild();
        this.getPage().getConversation().setAttribute(LogicContextImpl.class.getName(), null);
    }

    @Override
    @Nonnull
    public ILogicContext lc() throws Exception {
        ILogicContext lc = (ILogicContext)this.getPage().getConversation().getAttribute(LogicContextImpl.class.getName());
        if (null == lc) {
            lc = new LogicContextImpl(this.getSharedContext());
            this.getPage().getConversation().setAttribute(LogicContextImpl.class.getName(), lc);
        }
        return lc;
    }

    public void forceReloadData() throws Exception {
        this.resetAllSharedContexts();
        DomApplication.get().getInjector().injectPageValues(this, this.getPage().getPageParameters());
        this.forceRebuild();
    }

    public void resetAllSharedContexts() {
        this.getPage().getConversation().setAttribute(LogicContextImpl.class.getName(), null);
        QContextManager.closeSharedContexts((IQContextContainer)this.getPage().getConversation());
    }

    @Override
    public void componentHandleWebAction(@Nonnull RequestContextImpl ctx, @Nonnull String action) throws Exception {
        if ("notifyPage".equals(action)) {
            this.handleNotifyPageCommand(ctx);
        } else {
            super.componentHandleWebAction(ctx, action);
        }
    }

    private void handleNotifyPageCommand(@Nonnull IRequestContext ctx) throws Exception {
        String command = ctx.getParameter(this.getActualID() + "_command");
        INotifyPageEvent listener = this.getNotifyPageEvent();
        if (null != listener) {
            listener.execute(command);
        }
    }

    @Nullable
    public INotifyPageEvent getNotifyPageEvent() {
        return this.m_notifyPageEvent;
    }

    public void setNotifyPageEvent(@Nonnull INotifyPageEvent notifyPageEvent) {
        this.m_notifyPageEvent = notifyPageEvent;
    }
}

