/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.dom.webaction;

import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.webaction.IWebActionHandler;
import to.etc.domui.dom.webaction.JsonWebActionFactory;
import to.etc.domui.server.RequestContextImpl;
import to.etc.json.JSON;
import to.etc.util.WrappedException;

class JsonWebAction
implements IWebActionHandler {
    @Nonnull
    private final Method m_method;
    @Nonnull
    private final Class<?> m_formal;
    @Nonnull
    private final Type m_paramType;

    public JsonWebAction(@Nonnull Method method, @Nonnull Class<?> formal, @Nonnull Type paramType) {
        this.m_method = method;
        this.m_formal = formal;
        this.m_paramType = paramType;
    }

    @Override
    public void handleWebAction(@Nonnull NodeBase node, @Nonnull RequestContextImpl context, boolean responseExpected) throws Exception {
        String json = context.getParameter("json");
        if (null == json) {
            throw new IllegalArgumentException("The request parameter 'json' is missing for web action method " + this.m_method);
        }
        StringReader sr = new StringReader(json);
        Object decoded = JSON.decode(this.m_formal, (Type)this.m_paramType, (Reader)sr);
        try {
            Object response = this.m_method.invoke((Object)node, decoded);
            if (responseExpected && this.m_method.getReturnType() != Void.TYPE) {
                JsonWebActionFactory.renderResponse(this.m_method, context, response);
            }
        }
        catch (Exception x) {
            throw WrappedException.unwrap((Exception)x);
        }
    }
}

