/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.dom.webaction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.webaction.IWebActionHandler;
import to.etc.domui.server.RequestContextImpl;

public class WebActionRegistry {
    @Nonnull
    private final List<IFactory> m_factoryList = new ArrayList<IFactory>();
    @Nonnull
    private static final IWebActionHandler DUMMY = new IWebActionHandler(){

        @Override
        public void handleWebAction(@Nonnull NodeBase node, @Nonnull RequestContextImpl context, boolean responseExpected) throws Exception {
            throw new IllegalStateException("Stop calling me!");
        }
    };
    @Nonnull
    private final Map<Class<? extends NodeBase>, Map<String, IWebActionHandler>> m_map = new HashMap<Class<? extends NodeBase>, Map<String, IWebActionHandler>>();

    public synchronized void register(@Nonnull IFactory f) {
        this.m_factoryList.add(f);
    }

    @Nullable
    public synchronized IWebActionHandler findActionHandler(@Nonnull Class<? extends NodeBase> node, @Nonnull String actionCode) {
        Map<String, IWebActionHandler> map = this.m_map.get(node);
        if (null != map) {
            IWebActionHandler ah = map.get(actionCode);
            if (null != ah) {
                return ah == DUMMY ? null : ah;
            }
        } else {
            map = new HashMap<String, IWebActionHandler>();
            this.m_map.put(node, map);
        }
        for (IFactory f : this.m_factoryList) {
            IWebActionHandler handler = f.createHandler(node, actionCode);
            if (null == handler) continue;
            map.put(actionCode, handler);
            return handler;
        }
        map.put(actionCode, DUMMY);
        return null;
    }

    public static interface IFactory {
        @Nullable
        public IWebActionHandler createHandler(@Nonnull Class<? extends NodeBase> var1, @Nonnull String var2);
    }
}

