/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.injector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.DefaultNonNull;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import to.etc.domui.dom.html.UrlPage;
import to.etc.domui.injector.DefaultPageInjectorFactory;
import to.etc.domui.injector.IPageInjector;
import to.etc.domui.injector.IPageInjectorCalculator;
import to.etc.domui.injector.IPagePropertyFactory;
import to.etc.domui.injector.PageInjector;
import to.etc.domui.injector.PropertyInjector;
import to.etc.domui.state.IPageParameters;

@DefaultNonNull
public final class DefaultPageInjector
implements IPageInjector {
    private Map<String, PageInjector> m_injectorMap = new HashMap<String, PageInjector>();
    private final DefaultPageInjectorFactory m_defaultPageInjectorFactory;
    @GuardedBy(value="this")
    private List<InjectorReference> m_pageInjectorOrderList = Collections.emptyList();
    @GuardedBy(value="this")
    private List<IPageInjectorCalculator> m_pageInjectorList = Collections.emptyList();

    public DefaultPageInjector() {
        this.m_defaultPageInjectorFactory = new DefaultPageInjectorFactory();
        this.registerPageInjector(0, this.m_defaultPageInjectorFactory);
    }

    @Override
    public void registerFactory(int urgency, IPagePropertyFactory injector) {
        this.m_defaultPageInjectorFactory.registerFactory(urgency, injector);
    }

    public final PageInjector calculateInjectors(Class<? extends UrlPage> page) {
        HashMap<String, PropertyInjector> propInjectorMap = new HashMap<String, PropertyInjector>();
        for (IPageInjectorCalculator injector : this.getPageInjectorList()) {
            injector.calculatePageInjectors(propInjectorMap, page);
        }
        return new PageInjector(page, new ArrayList<PropertyInjector>(propInjectorMap.values()));
    }

    public synchronized void registerPageInjector(int urgency, IPageInjectorCalculator injector) {
        ArrayList<InjectorReference> list = new ArrayList<InjectorReference>(this.m_pageInjectorOrderList);
        list.add(new InjectorReference(urgency, injector));
        Collections.sort(list, (a, b) -> b.getPriority() - a.getPriority());
        this.m_pageInjectorOrderList = list;
        ArrayList res = new ArrayList(list.size());
        list.forEach(item -> res.add(item.getPageInjector()));
        this.m_pageInjectorList = Collections.unmodifiableList(res);
    }

    @Nonnull
    private synchronized List<IPageInjectorCalculator> getPageInjectorList() {
        return this.m_pageInjectorList;
    }

    private synchronized PageInjector findPageInjector(Class<? extends UrlPage> page) {
        String cn = page.getClass().getCanonicalName();
        PageInjector pij = this.m_injectorMap.get(cn);
        if (pij != null && pij.getPageClass() == page.getClass()) {
            return pij;
        }
        pij = this.calculateInjectors(page);
        this.m_injectorMap.put(cn, pij);
        return pij;
    }

    @Override
    public void injectPageValues(UrlPage page, IPageParameters papa) throws Exception {
        PageInjector pij = this.findPageInjector(page.getClass());
        pij.inject(page, papa);
    }

    @DefaultNonNull
    private static final class InjectorReference {
        private final int m_priority;
        private final IPageInjectorCalculator m_pageInjector;

        public InjectorReference(int priority, IPageInjectorCalculator pageInjector) {
            this.m_priority = priority;
            this.m_pageInjector = pageInjector;
        }

        public int getPriority() {
            return this.m_priority;
        }

        public IPageInjectorCalculator getPageInjector() {
            return this.m_pageInjector;
        }
    }
}

