/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.injector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.dom.html.UrlPage;
import to.etc.domui.injector.EntityPropertyInjectorFactory;
import to.etc.domui.injector.IPageInjectorCalculator;
import to.etc.domui.injector.IPagePropertyFactory;
import to.etc.domui.injector.PropertyInjector;
import to.etc.domui.injector.SimplePropertyInjectorFactory;
import to.etc.util.ClassUtil;
import to.etc.util.PropertyInfo;

public class DefaultPageInjectorFactory
implements IPageInjectorCalculator {
    private List<PropFactoryRef> m_orderedList = Collections.emptyList();
    private List<IPagePropertyFactory> m_list = Collections.emptyList();

    public DefaultPageInjectorFactory() {
        this.registerFactory(0, new SimplePropertyInjectorFactory());
        this.registerFactory(100, new EntityPropertyInjectorFactory());
    }

    public synchronized void registerFactory(int urgency, IPagePropertyFactory injector) {
        ArrayList<PropFactoryRef> list = new ArrayList<PropFactoryRef>(this.m_orderedList);
        list.add(new PropFactoryRef(urgency, injector));
        Collections.sort(list, (a, b) -> b.getPriority() - a.getPriority());
        this.m_orderedList = list;
        ArrayList res = new ArrayList(list.size());
        list.forEach(item -> res.add(item.getPropertyFactory()));
        this.m_list = Collections.unmodifiableList(res);
    }

    @Nonnull
    private synchronized List<IPagePropertyFactory> getFactoryList() {
        return this.m_list;
    }

    @Override
    public void calculatePageInjectors(Map<String, PropertyInjector> registrationMap, Class<? extends UrlPage> pageClass) {
        List propertyList = ClassUtil.getProperties(pageClass);
        for (PropertyInfo pi : propertyList) {
            PropertyInjector pij;
            if (registrationMap.containsKey(pi.getName()) || null == (pij = this.calculateInjector(pi))) continue;
            registrationMap.put(pi.getName(), pij);
        }
    }

    @Nullable
    protected PropertyInjector calculateInjector(PropertyInfo pi) {
        if (pi.getSetter() == null) {
            return null;
        }
        for (IPagePropertyFactory factory : this.getFactoryList()) {
            PropertyInjector injector = factory.calculateInjector(pi);
            if (null == injector) continue;
            return injector;
        }
        return null;
    }

    private static final class PropFactoryRef {
        private final int m_priority;
        private final IPagePropertyFactory m_propertyFactory;

        public PropFactoryRef(int priority, IPagePropertyFactory propertyFactory) {
            this.m_priority = priority;
            this.m_propertyFactory = propertyFactory;
        }

        public int getPriority() {
            return this.m_priority;
        }

        public IPagePropertyFactory getPropertyFactory() {
            return this.m_propertyFactory;
        }
    }
}

