/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.injector;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.annotation.DefaultNonNull;
import javax.annotation.Nullable;
import to.etc.domui.annotations.UIUrlParameter;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.injector.IPagePropertyFactory;
import to.etc.domui.injector.PropertyInjector;
import to.etc.domui.injector.UrlFindEntityByPkInjector;
import to.etc.util.ClassUtil;
import to.etc.util.PropertyInfo;
import to.etc.webapp.qsql.QJdbcTable;

@DefaultNonNull
public final class EntityPropertyInjectorFactory
implements IPagePropertyFactory {
    @Override
    @Nullable
    public PropertyInjector calculateInjector(PropertyInfo propertyInfo) {
        Method getter = propertyInfo.getGetter();
        if (null == getter) {
            return null;
        }
        UIUrlParameter upp = (UIUrlParameter)ClassUtil.findAnnotationIncludingSuperClasses((Method)getter, UIUrlParameter.class);
        if (null == upp) {
            return null;
        }
        String name = upp.name() == "$*$" ? propertyInfo.getName() : upp.name();
        Class<?> ent = upp.entity();
        if (ent == Object.class) {
            ent = getter.getReturnType();
        }
        if (!this.isValidEntity(ent)) {
            return null;
        }
        ClassMetaModel cmm = MetaManager.findClassMeta(ent);
        PropertyMetaModel<?> pmm = cmm.getPrimaryKey();
        if (pmm == null) {
            return null;
        }
        return new UrlFindEntityByPkInjector(propertyInfo.getSetter(), name, upp.mandatory(), ent, pmm);
    }

    private boolean isValidEntity(Class<?> clz) {
        if (clz.getAnnotation(QJdbcTable.class) != null) {
            return true;
        }
        for (Annotation annotation : clz.getAnnotations()) {
            if (!this.isValidEntity(annotation.annotationType().getName())) continue;
            return true;
        }
        return false;
    }

    private boolean isValidEntity(String name) {
        if ("javax.persistence.Entity".equals(name)) {
            return true;
        }
        return "javax.persistence.Table".equals(name);
    }
}

