/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.injector;

import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.converter.CompoundKeyConverter;
import to.etc.domui.dom.html.UrlPage;
import to.etc.domui.injector.PropertyInjector;
import to.etc.domui.state.IPageParameters;
import to.etc.webapp.query.QDataContext;
import to.etc.webapp.query.QNotFoundException;

public class UrlFindEntityByPkInjector
extends PropertyInjector {
    private final String m_name;
    private final boolean m_mandatory;
    private final Class<?> m_entityClass;
    private final PropertyMetaModel<?> m_pkMetaPmm;

    public UrlFindEntityByPkInjector(Method propertySetter, String name, boolean mandatory, Class<?> enityClass, PropertyMetaModel<?> pkMetaPmm) {
        super(propertySetter);
        this.m_name = name;
        this.m_mandatory = mandatory;
        this.m_entityClass = enityClass;
        this.m_pkMetaPmm = pkMetaPmm;
    }

    protected String getParameterName() {
        return this.m_name;
    }

    protected boolean isMandatory() {
        return this.m_mandatory;
    }

    protected String getParameterValue(UrlPage page, IPageParameters papa) throws Exception {
        String pv = papa.getString(this.m_name, null);
        if (pv == null) {
            if (this.m_mandatory) {
                throw new IllegalArgumentException("The page " + page.getClass() + " REQUIRES the URL parameter " + this.m_name);
            }
            return null;
        }
        return pv;
    }

    protected Object createNew(UrlPage page) {
        try {
            return this.m_entityClass.newInstance();
        }
        catch (Exception x) {
            throw new RuntimeException("Cannot create an instance of entity class '" + this.m_entityClass + "' for URL parameter=" + this.m_name + " of page=" + page.getClass() + ": " + x, x);
        }
    }

    protected boolean isNew(UrlPage page, IPageParameters papa, String value) throws Exception {
        return "NEW".equals(value);
    }

    protected Object getKeyInstance(QDataContext dc, UrlPage page, String pkValue) throws Exception {
        if (Number.class.isAssignableFrom(this.m_pkMetaPmm.getActualType()) && pkValue != null && pkValue.length() == 0) {
            return null;
        }
        Object pk = CompoundKeyConverter.INSTANCE.unmarshal(dc, this.m_pkMetaPmm.getActualType(), pkValue);
        if (pk == null) {
            throw new RuntimeException("URL parameter value='" + pkValue + "' converted to Null primary key value for entity class '" + this.m_entityClass + "' for URL parameter=" + this.m_name + " of page=" + page.getClass() + ": ");
        }
        return pk;
    }

    @Override
    public void inject(@Nonnull UrlPage page, @Nonnull IPageParameters papa) throws Exception {
        Object value;
        String pv = this.getParameterValue(page, papa);
        if (pv == null) {
            return;
        }
        if (this.isNew(page, papa, pv)) {
            value = this.createNew(page);
        } else {
            QDataContext dc = page.getSharedContext();
            Object pk = this.getKeyInstance(dc, page, pv);
            if (pk == null) {
                if (this.m_mandatory) {
                    throw new QNotFoundException(this.m_entityClass, pk);
                }
                return;
            }
            value = dc.find(this.m_entityClass, pk);
            if (value == null && this.m_mandatory) {
                throw new QNotFoundException(this.m_entityClass, pk);
            }
        }
        this.setValue(page, value);
    }
}

