/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.injector;

import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import to.etc.domui.converter.ConverterRegistry;
import to.etc.domui.dom.html.UrlPage;
import to.etc.domui.injector.PropertyInjector;
import to.etc.domui.state.IPageParameters;

public final class UrlParameterInjector
extends PropertyInjector {
    private final String m_name;
    private final boolean m_mandatory;

    public UrlParameterInjector(Method propertySetter, String name, boolean mandatory) {
        super(propertySetter);
        this.m_name = name;
        this.m_mandatory = mandatory;
    }

    @Override
    public void inject(@Nonnull UrlPage page, @Nonnull IPageParameters papa) throws Exception {
        Object value;
        String pv = papa.getString(this.m_name, null);
        if (pv == null) {
            if (this.m_mandatory) {
                throw new IllegalArgumentException("The page " + page.getClass() + " REQUIRES the URL parameter " + this.m_name);
            }
            return;
        }
        Class<?> type = this.getPropertySetter().getParameterTypes()[0];
        try {
            value = ConverterRegistry.convertURLStringToValue(type, pv);
        }
        catch (Exception x) {
            throw new RuntimeException("Cannot convert the string '" + pv + "' to type=" + type + ", for URL parameter=" + this.m_name + " of page=" + page.getClass() + ": " + x, x);
        }
        try {
            this.getPropertySetter().invoke((Object)page, value);
        }
        catch (Exception x) {
            throw new RuntimeException("Cannot SET the value '" + value + "' converted from the string '" + pv + "' to type=" + type + ", for URL parameter=" + this.m_name + " of page=" + page.getClass() + ": " + x, x);
        }
    }
}

