/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.log;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.buttons.DefaultButton;
import to.etc.domui.component.buttons.LinkButton;
import to.etc.domui.component.layout.ButtonBar;
import to.etc.domui.component.ntbl.ExpandingEditTable;
import to.etc.domui.component.ntbl.IRowEditorEvent;
import to.etc.domui.component.ntbl.IRowEditorFactory;
import to.etc.domui.component.tbl.BasicRowRenderer;
import to.etc.domui.component.tbl.SimpleListModel;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.log.HandlerRowEditor;
import to.etc.domui.log.data.Handler;
import to.etc.domui.log.data.HandlerType;
import to.etc.domui.log.tailer.ServerLogPage;
import to.etc.domui.util.INodeContentRenderer;
import to.etc.domui.util.Msgs;
import to.etc.log.EtcLoggerFactory;
import to.etc.webapp.nls.BundleRef;

public class ConfigPart
extends Div {
    protected static final BundleRef BUNDLE = Msgs.BUNDLE;
    private final List<Handler> m_handlers;
    private ExpandingEditTable<Handler> m_table;
    private IRowEditorEvent<Handler, HandlerRowEditor> m_rowChangeListener;
    private SimpleListModel<Handler> m_model;
    private final String[] m_cols = new String[]{"type", "file", "format"};
    private ButtonBar m_buttonBar;

    public ConfigPart(@Nonnull List<Handler> handlers) {
        this.m_handlers = handlers;
    }

    @Override
    public void createContent() throws Exception {
        super.createContent();
        this.createButtonBar();
        this.createButtons();
        this.m_model = new SimpleListModel<Handler>(this.m_handlers);
        BasicRowRenderer<Handler> rr = new BasicRowRenderer<Handler>(Handler.class, this.m_cols);
        rr.addColumns("", "^follow", "%10", new INodeContentRenderer<Handler>(){

            @Override
            public void renderNodeContent(@Nonnull NodeBase component, @Nonnull NodeContainer node, final @Nullable Handler handler, @Nullable Object parameters) throws Exception {
                if (handler != null && handler.getType() == HandlerType.FILE) {
                    node.add(new LinkButton("follow", (IClicked<? extends NodeBase>)new IClicked<LinkButton>(){

                        @Override
                        public void clicked(@Nonnull LinkButton clickednode) throws Exception {
                            ServerLogPage.moveSub(ConfigPart.this.constructLogPath(handler.getFile()));
                        }
                    }));
                }
            }
        });
        this.m_table = new ExpandingEditTable<Handler>(Handler.class, this.m_model, rr);
        this.m_table.setNewAtStart(true);
        this.m_table.setEnableDeleteButton(true);
        this.m_table.setEnableExpandItems(true);
        this.m_table.setOnRowChangeCompleted(this.getRowChangeListener());
        this.m_table.setEditorFactory((IRowEditorFactory<Handler, NodeContainer>)new IRowEditorFactory<Handler, HandlerRowEditor>(){

            @Override
            @Nonnull
            public HandlerRowEditor createRowEditor(@Nonnull Handler instance, boolean isnew, boolean isReadonly) throws Exception {
                return new HandlerRowEditor(instance, ConfigPart.this.m_table);
            }
        });
        this.add(this.m_table);
    }

    protected String constructLogPath(@Nonnull String fileName) {
        return EtcLoggerFactory.getSingleton().composeFullLogFileName(fileName);
    }

    protected void createButtonBar() {
        this.add(this.getButtonBar());
    }

    @Nonnull
    public ButtonBar getButtonBar() {
        if (this.m_buttonBar == null) {
            this.m_buttonBar = new ButtonBar();
        }
        return this.m_buttonBar;
    }

    protected void createButtons() throws Exception {
        this.createAddButton();
    }

    private void createAddButton() {
        this.getButtonBar().addButton(BUNDLE.getString("lookupform.new"), "THEME/btnNew.png", new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton b) throws Exception {
                ConfigPart.this.m_table.addNew(ConfigPart.this.initializeNewInstance());
            }
        });
    }

    @Nonnull
    protected Handler initializeNewInstance() {
        Handler handler = new Handler(HandlerType.FILE, "logger1");
        handler.setFormat("%d %p %mdc{loginId}\t%t [%l] %msg");
        return handler;
    }

    protected IRowEditorEvent<Handler, HandlerRowEditor> getRowChangeListener() {
        return this.m_rowChangeListener;
    }

    protected void setRowChangeListener(IRowEditorEvent<Handler, HandlerRowEditor> rowChangeListener) {
        this.m_rowChangeListener = rowChangeListener;
    }

    public boolean validateData() {
        return true;
    }
}

