/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.log;

import javax.annotation.Nonnull;
import to.etc.domui.component.form.HorizontalFormBuilder;
import to.etc.domui.component.tbl.TableModelTableBase;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.IValueChanged;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.TextNode;
import to.etc.domui.log.RowEditorBase;
import to.etc.domui.log.data.Filter;
import to.etc.log.handler.LogFilterType;

public class FilterRowEditor
extends RowEditorBase<Filter> {
    private IControl<LogFilterType> m_typeCtl;
    private IControl<String> m_keyCtl;
    private TextNode m_holder;

    public FilterRowEditor(Filter instance, TableModelTableBase<Filter> model, String[] cols) {
        super(instance, model, cols);
    }

    @Override
    protected void addProperties(HorizontalFormBuilder builder) {
        this.m_typeCtl = builder.addProp("type");
        this.m_keyCtl = builder.addProp("key");
        builder.addProp("value");
    }

    @Override
    protected void afterCreateContent() throws Exception {
        super.afterCreateContent();
        this.m_holder = new TextNode(this.m_keyCtl.getValueSafe());
        this.m_typeCtl.setOnValueChanged(new IValueChanged<NodeBase>(){

            @Override
            public void onValueChanged(@Nonnull NodeBase component) throws Exception {
                FilterRowEditor.this.updateKeyByType(FilterRowEditor.this.m_typeCtl, FilterRowEditor.this.m_keyCtl, FilterRowEditor.this.m_holder);
            }
        });
        if (LogFilterType.SESSION == this.m_typeCtl.getValue()) {
            this.updateKeyByType(this.m_typeCtl, this.m_keyCtl, this.m_holder);
        }
    }

    private void updateKeyByType(IControl<LogFilterType> typeCtl, IControl<String> keyCtl, TextNode holder) {
        LogFilterType type = typeCtl.getValue();
        keyCtl.setDisabled(type == LogFilterType.SESSION);
        if (type == LogFilterType.SESSION) {
            holder.setText(keyCtl.getValueSafe());
            keyCtl.setValue("session");
        } else {
            keyCtl.setValue(holder.getText());
        }
    }
}

