/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.log;

import javax.annotation.Nonnull;
import to.etc.domui.component.buttons.LinkButton;
import to.etc.domui.component.controlfactory.ModelBindings;
import to.etc.domui.component.form.HorizontalFormBuilder;
import to.etc.domui.component.input.TextStr;
import to.etc.domui.component.layout.ErrorMessageDiv;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.ntbl.ExpandingEditTable;
import to.etc.domui.component.ntbl.IEditor;
import to.etc.domui.component.ntbl.IRowEditorEvent;
import to.etc.domui.component.ntbl.IRowEditorFactory;
import to.etc.domui.component.tbl.BasicRowRenderer;
import to.etc.domui.component.tbl.SimpleListModel;
import to.etc.domui.component.tbl.TableModelTableBase;
import to.etc.domui.dom.css.VerticalAlignType;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.IValueChanged;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.TR;
import to.etc.domui.dom.html.Table;
import to.etc.domui.dom.html.TextNode;
import to.etc.domui.log.FilterRowEditor;
import to.etc.domui.log.RowEditorBase;
import to.etc.domui.log.data.Filter;
import to.etc.domui.log.data.Handler;
import to.etc.domui.log.data.HandlerType;
import to.etc.domui.log.data.Matcher;
import to.etc.domui.util.Msgs;
import to.etc.log.EtcLoggerFactory;
import to.etc.log.handler.LogFilterType;
import to.etc.webapp.nls.BundleRef;

public class HandlerRowEditor
extends Div
implements IEditor {
    protected static final BundleRef BUNDLE = Msgs.BUNDLE;
    private final Handler m_instance;
    private final TableModelTableBase<Handler> m_model;
    private HorizontalFormBuilder m_builder;
    private ModelBindings m_bindings;
    private ExpandingEditTable<Matcher> m_tableMatchers;
    private SimpleListModel<Matcher> m_modelMatchers;
    private ExpandingEditTable<Filter> m_tableFilters;
    private SimpleListModel<Filter> m_modelFilters;
    private String m_formatHelp = null;

    @Override
    public boolean validate(boolean isnew) throws Exception {
        this.m_bindings.moveControlToModel();
        return true;
    }

    public HandlerRowEditor(Handler instance, TableModelTableBase<Handler> model) {
        this.m_instance = instance;
        this.m_model = model;
    }

    @Override
    public void createContent() throws Exception {
        super.createContent();
        this.add(new ErrorMessageDiv(this, true));
        Table layout = new Table();
        this.add(layout);
        TR row = layout.addBody().addRow();
        row.setVerticalAlign(VerticalAlignType.TOP);
        TD part1 = row.addCell();
        this.addHandlerPart(part1);
        TD part2 = row.addCell();
        part2.setPaddingLeft("10px");
        this.addMatcherPart(part2);
        TD part3 = row.addCell();
        part3.setPaddingLeft("10px");
        this.addFilterPart(part3);
    }

    private void addHandlerPart(NodeContainer container) throws Exception {
        this.m_builder = new HorizontalFormBuilder(this.m_instance);
        final IControl<HandlerType> typeCtl = this.m_builder.addProp("type");
        final IControl<String> nameCtl = this.m_builder.addProp("file");
        TextStr formatCtl = new TextStr();
        formatCtl.setMaxLength(150);
        formatCtl.setSize(60);
        formatCtl.setTitle(this.getFormatHelp());
        this.m_builder.addProp("format", formatCtl);
        container.add(this.m_builder.finish());
        this.m_bindings = this.m_builder.getBindings();
        this.m_bindings.moveModelToControl();
        final TextNode holder = new TextNode((String)nameCtl.getValueSafe());
        typeCtl.setOnValueChanged(new IValueChanged<NodeBase>(){

            @Override
            public void onValueChanged(@Nonnull NodeBase component) throws Exception {
                HandlerRowEditor.this.updateNameByType(typeCtl, nameCtl, holder);
            }
        });
        if (HandlerType.STDOUT == typeCtl.getValue()) {
            this.updateNameByType(typeCtl, nameCtl, holder);
        }
    }

    private String getFormatHelp() {
        if (this.m_formatHelp == null) {
            this.m_formatHelp = this.$("format.help", new Object[0]);
        }
        return this.m_formatHelp;
    }

    private void updateNameByType(IControl<HandlerType> typeCtl, IControl<String> nameCtl, TextNode holder) {
        HandlerType type = typeCtl.getValue();
        nameCtl.setDisabled(type == HandlerType.STDOUT);
        if (type == HandlerType.STDOUT) {
            holder.setText(nameCtl.getValueSafe());
            nameCtl.setValue("console");
        } else {
            nameCtl.setValue(holder.getText());
        }
    }

    private void addMatcherPart(NodeContainer container) throws Exception {
        container.add(new LinkButton(this.$("add.matcher", new Object[0]), (IClicked<? extends NodeBase>)new IClicked<LinkButton>(){

            @Override
            public void clicked(@Nonnull LinkButton clickednode) throws Exception {
                HandlerRowEditor.this.m_tableMatchers.addNew(new Matcher("", EtcLoggerFactory.getSingleton().getDefaultLevel()));
            }
        }));
        this.m_modelMatchers = new SimpleListModel<Matcher>(this.m_instance.getMatchers());
        Object[] cols = new String[]{"name", "level"};
        BasicRowRenderer<Matcher> rr = new BasicRowRenderer<Matcher>(Matcher.class, cols);
        this.m_tableMatchers = new ExpandingEditTable<Matcher>(Matcher.class, this.m_modelMatchers, rr);
        this.m_tableMatchers.setNewAtStart(true);
        this.m_tableMatchers.setEnableDeleteButton(true);
        this.m_tableMatchers.setEnableExpandItems(true);
        this.m_tableMatchers.setOnRowChangeCompleted(new IRowEditorEvent<Matcher, RowEditorBase<Matcher>>(){

            @Override
            public boolean onRowChanged(@Nonnull TableModelTableBase<Matcher> tablecomponent, @Nonnull RowEditorBase<Matcher> editor, @Nonnull Matcher instance, boolean isNew) throws Exception {
                if (MetaManager.hasDuplicates(HandlerRowEditor.this.m_modelMatchers.getItems(0, HandlerRowEditor.this.m_modelMatchers.getRows()), instance, "name")) {
                    editor.setMessage(UIMessage.error("name", Msgs.BUNDLE, "v.invalid.not.unique", new Object[0]));
                    return false;
                }
                return true;
            }
        });
        this.m_tableMatchers.setEditorFactory((IRowEditorFactory<Matcher, NodeContainer>)new IRowEditorFactory<Matcher, RowEditorBase<Matcher>>((String[])cols){
            final /* synthetic */ String[] val$cols;
            {
                this.val$cols = stringArray;
            }

            @Override
            @Nonnull
            public RowEditorBase<Matcher> createRowEditor(@Nonnull Matcher instance, boolean isnew, boolean isReadonly) throws Exception {
                return new RowEditorBase<Matcher>(instance, HandlerRowEditor.this.m_tableMatchers, this.val$cols);
            }
        });
        container.add(this.m_tableMatchers);
    }

    private void addFilterPart(TD container) throws Exception {
        container.add(new LinkButton(this.$("add.filter", new Object[0]), (IClicked<? extends NodeBase>)new IClicked<LinkButton>(){

            @Override
            public void clicked(@Nonnull LinkButton clickednode) throws Exception {
                HandlerRowEditor.this.m_tableFilters.addNew(new Filter(LogFilterType.MDC, "loginId", "USER1"));
            }
        }));
        this.m_modelFilters = new SimpleListModel<Filter>(this.m_instance.getFilters());
        Object[] cols = new String[]{"type", "key", "value"};
        BasicRowRenderer<Filter> rr = new BasicRowRenderer<Filter>(Filter.class, cols);
        this.m_tableFilters = new ExpandingEditTable<Filter>(Filter.class, this.m_modelFilters, rr);
        this.m_tableFilters.setNewAtStart(true);
        this.m_tableFilters.setEnableDeleteButton(true);
        this.m_tableFilters.setEnableExpandItems(true);
        this.m_tableFilters.setOnRowChangeCompleted(new IRowEditorEvent<Filter, FilterRowEditor>(){

            @Override
            public boolean onRowChanged(@Nonnull TableModelTableBase<Filter> tablecomponent, @Nonnull FilterRowEditor editor, @Nonnull Filter instance, boolean isNew) throws Exception {
                if (MetaManager.hasDuplicates(HandlerRowEditor.this.m_modelFilters.getItems(0, HandlerRowEditor.this.m_modelFilters.getRows()), instance, "key")) {
                    editor.setMessage(UIMessage.error("key", Msgs.BUNDLE, "v.invalid.not.unique", new Object[0]));
                    return false;
                }
                return true;
            }
        });
        this.m_tableFilters.setEditorFactory((IRowEditorFactory<Filter, NodeContainer>)new IRowEditorFactory<Filter, FilterRowEditor>((String[])cols){
            final /* synthetic */ String[] val$cols;
            {
                this.val$cols = stringArray;
            }

            @Override
            @Nonnull
            public FilterRowEditor createRowEditor(@Nonnull Filter instance, boolean isnew, boolean isReadonly) throws Exception {
                return new FilterRowEditor(instance, HandlerRowEditor.this.m_tableFilters, this.val$cols);
            }
        });
        container.add(this.m_tableFilters);
    }
}

