/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.log;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import to.etc.domui.component.buttons.DefaultButton;
import to.etc.domui.component.controlfactory.ModelBindings;
import to.etc.domui.component.form.TabularFormBuilder;
import to.etc.domui.component.layout.ButtonBar;
import to.etc.domui.component.misc.MessageFlare;
import to.etc.domui.component.misc.UIControlUtil;
import to.etc.domui.dom.css.FontStyle;
import to.etc.domui.dom.errors.MsgType;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.IUserInputModifiedFence;
import to.etc.domui.dom.html.Label;
import to.etc.domui.dom.html.UrlPage;
import to.etc.domui.log.ConfigPart;
import to.etc.domui.log.data.Filter;
import to.etc.domui.log.data.Handler;
import to.etc.domui.log.data.HandlerType;
import to.etc.domui.log.data.LoggerRootDef;
import to.etc.domui.log.data.Matcher;
import to.etc.domui.state.UIGoto;
import to.etc.domui.util.Msgs;
import to.etc.log.EtcLoggerFactory;
import to.etc.log.Level;
import to.etc.log.handler.LogFilterType;
import to.etc.webapp.nls.BundleRef;

public class LoggerConfigPage
extends UrlPage
implements IUserInputModifiedFence {
    static final BundleRef BUNDLE = Msgs.BUNDLE;
    private ButtonBar m_buttonBar;
    private DefaultButton m_saveButton;
    private DefaultButton m_cancelButton;
    private boolean m_modified;
    private Label m_notSavedInfo;
    private final List<Handler> m_handlers = new ArrayList<Handler>();
    private ConfigPart m_configPart;
    private LoggerRootDef m_rootDef;
    private ModelBindings m_rootDefBindings;

    @Override
    public void createContent() throws Exception {
        super.createContent();
        this.createButtonBar();
        this.createButtons();
    }

    protected void createButtonBar() {
        this.add(this.getButtonBar());
    }

    public ButtonBar getButtonBar() {
        if (this.m_buttonBar == null) {
            this.m_buttonBar = new ButtonBar();
        }
        return this.m_buttonBar;
    }

    protected void createButtons() throws Exception {
        this.createCommitButton();
        this.createCancelButton();
        this.createConfigPanel();
    }

    private void createConfigPanel() throws Exception {
        this.addRootConfigPart();
        Document doc = EtcLoggerFactory.getSingleton().toXml(true);
        this.loadXml(doc);
        this.m_configPart = new ConfigPart(this.m_handlers);
        this.add(this.m_configPart);
    }

    private void loadXml(Document doc) {
        this.m_handlers.clear();
        NodeList handlerNodes = doc.getElementsByTagName("handler");
        for (int i = 0; i < handlerNodes.getLength(); ++i) {
            Node handlerNode = handlerNodes.item(i);
            this.m_handlers.add(this.loadHandler(handlerNode));
        }
    }

    private Handler loadHandler(Node handlerNode) {
        HandlerType type = "file".equalsIgnoreCase(handlerNode.getAttributes().getNamedItem("type").getNodeValue()) ? HandlerType.FILE : HandlerType.STDOUT;
        String file = null;
        if (type == HandlerType.FILE) {
            file = handlerNode.getAttributes().getNamedItem("file").getNodeValue();
        }
        Handler handler = new Handler(type, file);
        NodeList nodes = handlerNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if ("log".equals(node.getNodeName())) {
                handler.addMatcher(this.loadMatcher(node));
                continue;
            }
            if ("filter".equals(node.getNodeName())) {
                handler.addFilter(this.loadFilter(node));
                continue;
            }
            if (!"format".equals(node.getNodeName())) continue;
            handler.setFormat(this.loadFormat(node));
        }
        if (handler.getFormat() == null) {
            handler.setFormat("%d %p %mdc{loginId}\t%t [%l] %msg");
        }
        return handler;
    }

    private String loadFormat(Node node) {
        String format = node.getAttributes().getNamedItem("pattern").getNodeValue();
        return format;
    }

    private Matcher loadMatcher(Node node) {
        String name = node.getAttributes().getNamedItem("name").getNodeValue();
        Level level = Level.valueOf((String)node.getAttributes().getNamedItem("level").getNodeValue());
        return new Matcher(name, level);
    }

    private Filter loadFilter(Node node) {
        LogFilterType type = "mdc".equalsIgnoreCase(node.getAttributes().getNamedItem("type").getNodeValue()) ? LogFilterType.MDC : LogFilterType.SESSION;
        String key = "session";
        if (type != LogFilterType.SESSION) {
            key = node.getAttributes().getNamedItem("key").getNodeValue();
        }
        String value = node.getAttributes().getNamedItem("value").getNodeValue();
        return new Filter(type, key, value);
    }

    private void addRootConfigPart() throws Exception {
        this.m_rootDef = new LoggerRootDef(EtcLoggerFactory.getSingleton().getRootDir(), EtcLoggerFactory.getSingleton().logDirOriginalAsConfigured(), EtcLoggerFactory.getSingleton().getLogDir());
        TabularFormBuilder tbl = new TabularFormBuilder(this.m_rootDef);
        tbl.addProps("rootDir", "logDir");
        if (!this.m_rootDef.getLogDir().equals(this.m_rootDef.getLogDirAbsolute())) {
            Label calculatedPath = new Label(this.m_rootDef.getLogDirAbsolute());
            tbl.addLabelAndControl("log dir path", calculatedPath, false);
        }
        this.m_rootDefBindings = tbl.getBindings();
        this.m_rootDefBindings.moveModelToControl();
        this.add(tbl.finish());
    }

    protected void createCommitButton() {
        this.m_saveButton = this.getButtonBar().addButton(BUNDLE.getString("edlg.okay"), "THEME/btnSave.png", new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton b) throws Exception {
                LoggerConfigPage.this.save();
            }
        });
        this.m_saveButton.setDisabled(true);
        this.m_saveButton.setTitle("no changes to save");
    }

    protected void createCancelButton() {
        this.m_cancelButton = this.getButtonBar().addButton(BUNDLE.getString("edlg.cancel"), "THEME/btnCancel.png", new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton b) throws Exception {
                LoggerConfigPage.this.reloadPageData();
            }
        });
        this.m_cancelButton.setDisabled(true);
    }

    protected void onAfterSave() throws Exception {
        this.reloadPageData();
        MessageFlare.display(this, MsgType.INFO, this.$("data.saved", new Object[0]));
    }

    protected void save() throws Exception {
        if (this.validateData()) {
            this.onSave();
            this.onAfterSave();
        }
    }

    private boolean validateData() throws Exception {
        this.m_rootDefBindings.moveControlToModel();
        return this.m_configPart.validateData();
    }

    private void onSave() throws Exception {
        Document doc = this.toXml();
        EtcLoggerFactory.getSingleton().loadConfig(doc);
        EtcLoggerFactory.getSingleton().saveConfig();
    }

    private Document toXml() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        Element rootElement = doc.createElement("config");
        doc.appendChild(rootElement);
        rootElement.setAttribute("logLocation", this.m_rootDef.getLogDir());
        for (Handler handler : this.m_handlers) {
            Element handlerNode = doc.createElement("handler");
            rootElement.appendChild(handlerNode);
            handler.saveToXml(doc, handlerNode);
        }
        return doc;
    }

    protected void reloadPageData() throws Exception {
        UIGoto.reload();
    }

    @Override
    public boolean isModified() {
        return this.m_modified;
    }

    @Override
    public void setModified(boolean modified) {
        this.m_modified = modified;
    }

    @Override
    public boolean isFinalUserInputModifiedFence() {
        return true;
    }

    @Override
    public void onModifyFlagRaised() {
        if (this.m_saveButton != null) {
            this.m_saveButton.setDisabled(false);
            this.m_saveButton.setTitle(null);
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.setDisabled(false);
        }
        if (this.m_notSavedInfo == null) {
            this.addNotSavedWarning();
        }
    }

    private void addNotSavedWarning() {
        if (this.m_buttonBar != null && this.m_notSavedInfo == null) {
            this.m_notSavedInfo = new Label(this.$("data.modified", new Object[0]));
            this.m_notSavedInfo.setFontStyle(FontStyle.ITALIC);
            this.m_notSavedInfo.setColor(UIControlUtil.getRgbHex(Color.RED, true));
            this.m_buttonBar.appendAfterMe(this.m_notSavedInfo);
        }
    }
}

