/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.log;

import java.sql.Connection;
import java.util.Date;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import to.etc.domui.component.buttons.DefaultButton;
import to.etc.domui.dom.html.BR;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.UrlPage;
import to.etc.webapp.qsql.JdbcUtil;

public class TestLoggerPage
extends UrlPage {
    private static Logger LOG = LoggerFactory.getLogger(TestLoggerPage.class);

    @Override
    public void createContent() throws Exception {
        super.createContent();
        this.add(new DefaultButton("Click to log line", new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton clickednode) throws Exception {
                LOG.debug("debug log");
                LOG.trace("trace log");
                LOG.info("info log");
                LOG.warn("warn log");
                LOG.error("error log");
                TestLoggerPage.this.add("Added lines to log");
                TestLoggerPage.this.add(new BR());
            }
        }));
        this.add(new DefaultButton("Click to set MDC page=AAA", new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton clickednode) throws Exception {
                MDC.put((String)"page", (String)"AAA");
                TestLoggerPage.this.add("Added MDC AAA");
                TestLoggerPage.this.add(new BR());
            }
        }));
        this.add(new DefaultButton("Click to set MDC page=BBB", new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton clickednode) throws Exception {
                MDC.put((String)"page", (String)"BBB");
                TestLoggerPage.this.add("Added MDC BBB");
                TestLoggerPage.this.add(new BR());
            }
        }));
        this.add(new DefaultButton("Click to log formatted INFO mesages", new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton clickednode) throws Exception {
                LOG.info("Info Log that uses format 1 part message, values: {}", (Object)"[value1]");
                LOG.info("Info Log that uses format 2 parts message, values: {} {}", (Object)"[value1]", (Object)"[value2]");
                LOG.info("Info Log that uses format 3 parts message, values: {} {} {}", (Object[])new String[]{"[value1]", "[value2]", "[value3]"});
                TestLoggerPage.this.add("Added formatted lines to log");
                TestLoggerPage.this.add(new BR());
            }
        }));
        this.add(new DefaultButton("Click to log simple exception", new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton clickednode) throws Exception {
                LOG.error("Example of simple exception logging.", (Throwable)new Exception("This is some exception logged."));
                try {
                    Integer.parseInt("THIS IS NOT A INTEGER!");
                }
                catch (Exception ex) {
                    LOG.error("Example of simple exception logging.", (Throwable)ex);
                }
                TestLoggerPage.this.add("Added simple exception to log");
                TestLoggerPage.this.add(new BR());
            }
        }));
        this.add(new DefaultButton("Click to log nested exception", new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton clickednode) throws Exception {
                try {
                    Integer.parseInt("THIS IS NOT A INTEGER!");
                }
                catch (Exception ex) {
                    LOG.error("Example of nested exception logging.", (Throwable)new IllegalStateException("hah", new IllegalStateException("bah", new IllegalStateException("ah ah", new IllegalStateException("uh uh", new IllegalStateException("oh oh", new IllegalStateException("This is so unespected ;)", ex)))))));
                }
                TestLoggerPage.this.add("Added nested exception to log");
                TestLoggerPage.this.add(new BR());
            }
        }));
        this.add(new DefaultButton("Click to log SQL exception", new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton clickednode) throws Exception {
                try {
                    JdbcUtil.oracleSpCall((Connection)TestLoggerPage.this.getSharedContext().getConnection(), Integer.class, (String)"TestStoredProcedure", (Object[])new Object[]{new Date(), 5, "param3"});
                }
                catch (Exception ex) {
                    LOG.error("Example of SQL exception logging.", (Throwable)ex);
                }
                TestLoggerPage.this.add("Added SQL exception to log");
                TestLoggerPage.this.add(new BR());
            }
        }));
    }
}

