/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.log.data;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import to.etc.domui.component.meta.MetaProperty;
import to.etc.domui.component.meta.YesNoType;
import to.etc.domui.log.data.Filter;
import to.etc.domui.log.data.HandlerType;
import to.etc.domui.log.data.Matcher;
import to.etc.domui.util.DomUtil;

public class Handler {
    private HandlerType m_type;
    public static final String pTYPE = "type";
    private String m_file;
    public static final String pFILE = "file";
    private String m_format;
    public static final String pFORMAT = "format";
    public List<Matcher> m_matchers = new ArrayList<Matcher>();
    public static final String pMATCHERS = "matchers";
    public List<Filter> m_filters = new ArrayList<Filter>();
    public static final String pFILTERS = "filters";

    public Handler(HandlerType type, String file) {
        this.m_type = type;
        this.m_file = file;
    }

    @MetaProperty(length=30, required=YesNoType.YES, displaySize=20)
    public String getFile() {
        return this.m_file;
    }

    public void setFile(String file) {
        this.m_file = file;
    }

    @MetaProperty(required=YesNoType.YES)
    public HandlerType getType() {
        return this.m_type;
    }

    public void setType(HandlerType type) {
        this.m_type = type;
    }

    @MetaProperty(length=150, required=YesNoType.NO, displaySize=100)
    public String getFormat() {
        return this.m_format;
    }

    public void setFormat(String format) {
        this.m_format = format;
    }

    public List<Matcher> getMatchers() {
        return this.m_matchers;
    }

    public void setMatchers(List<Matcher> matchers) {
        this.m_matchers = matchers;
    }

    public List<Filter> getFilters() {
        return this.m_filters;
    }

    public void setFilters(List<Filter> filters) {
        this.m_filters = filters;
    }

    public void addMatcher(@Nonnull Matcher matcher) {
        this.m_matchers.add(matcher);
    }

    public void addFilter(@Nonnull Filter filter) {
        this.m_filters.add(filter);
    }

    public void saveToXml(Document doc, Element handlerNode) {
        handlerNode.setAttribute(pTYPE, this.m_type == HandlerType.STDOUT ? "stdout" : pFILE);
        if (this.m_type != HandlerType.STDOUT) {
            handlerNode.setAttribute(pFILE, this.m_file);
        }
        if (!DomUtil.isBlank(this.getFormat()) && !"%d %p %mdc{loginId}\t%t [%l] %msg".equalsIgnoreCase(this.getFormat())) {
            Element formatNode = doc.createElement(pFORMAT);
            handlerNode.appendChild(formatNode);
            formatNode.setAttribute("pattern", this.getFormat());
        }
        for (Matcher matcher : this.m_matchers) {
            Element logNode = doc.createElement("log");
            handlerNode.appendChild(logNode);
            matcher.saveToXml(doc, logNode);
        }
        for (Filter filter : this.m_filters) {
            Element filterNode = doc.createElement("filter");
            handlerNode.appendChild(filterNode);
            filter.saveToXml(doc, filterNode);
        }
    }
}

