/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.log.tailer;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import to.etc.domui.component.buttons.SmallImgButton;
import to.etc.domui.component.delayed.PollingDiv;
import to.etc.domui.component.input.ComboFixed;
import to.etc.domui.component.input.Text;
import to.etc.domui.component.input.ValueLabelPair;
import to.etc.domui.dom.html.BR;
import to.etc.domui.dom.html.Checkbox;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.IValueChanged;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.Span;
import to.etc.domui.log.tailer.LogTailerTask;
import to.etc.util.StringTool;

public class LogTailerFragment
extends PollingDiv {
    @Nonnull
    private final String m_logpath;
    private LogTailerTask m_task;
    private final Div m_lineDiv = new Div();
    private long m_oldSize = -1L;
    private int m_oldLines = -999;
    private int m_startLine;
    private Checkbox m_followBox;
    private Text<Integer> m_goto;
    private Span m_lineSpan;
    private Span m_szSpan;
    private ComboFixed<Integer> m_linesCombo;
    private boolean m_noFile;
    private static int[] SIZES = new int[]{32, 50, 60, 70, 80, 90, 100, 110, 120};

    public LogTailerFragment(String logpath) {
        this.m_logpath = logpath;
    }

    private boolean createTask() throws Exception {
        if (this.m_task != null) {
            throw new IllegalStateException("task already created!");
        }
        this.m_task = new LogTailerTask(this.m_logpath);
        this.getPage().getConversation().setAttribute("xx", this.m_task);
        return this.m_task.start();
    }

    @Override
    public void createContent() throws Exception {
        if (!this.createTask()) {
            this.m_noFile = true;
            this.showNoFileError();
            return;
        }
        this.createHeader();
        this.add(this.m_lineDiv);
        this.updateSizes();
        this.updateLines(0);
    }

    private void showNoFileError() {
        this.add("Log file does not exists yet: " + this.m_logpath);
        this.add(new BR());
        this.add("Go back and try to follow log later.");
    }

    private void createHeader() {
        Div ttl = new Div();
        this.add(ttl);
        ttl.setCssClass("ui-tlf-hdr");
        Div btn = new Div();
        ttl.add(btn);
        btn.setCssClass("ui-tlf-btn");
        SmallImgButton ib = new SmallImgButton("img/btnFirst.png", new IClicked<SmallImgButton>(){

            @Override
            public void clicked(@Nonnull SmallImgButton clickednode) throws Exception {
                LogTailerFragment.this.gotoLine(0);
            }
        });
        btn.add(ib);
        ib = new SmallImgButton("img/btnPrev.png", new IClicked<SmallImgButton>(){

            @Override
            public void clicked(@Nonnull SmallImgButton clickednode) throws Exception {
                int lnr = LogTailerFragment.this.m_startLine - LogTailerFragment.this.getLinesPerPage();
                if (lnr < 0) {
                    lnr = 0;
                }
                LogTailerFragment.this.gotoLine(lnr);
            }
        });
        btn.add(ib);
        ib = new SmallImgButton("img/btnNext.png", new IClicked<SmallImgButton>(){

            @Override
            public void clicked(@Nonnull SmallImgButton clickednode) throws Exception {
                int last = LogTailerFragment.this.m_task.getLastLine();
                int lnr = LogTailerFragment.this.m_startLine + LogTailerFragment.this.getLinesPerPage();
                if (lnr > last) {
                    lnr = last - LogTailerFragment.this.getLinesPerPage();
                }
                LogTailerFragment.this.gotoLine(lnr);
            }
        });
        btn.add(ib);
        ib = new SmallImgButton("img/btnLast.png", new IClicked<SmallImgButton>(){

            @Override
            public void clicked(@Nonnull SmallImgButton clickednode) throws Exception {
                LogTailerFragment.this.gotoLine(LogTailerFragment.this.m_task.getLastLine() - LogTailerFragment.this.getLinesPerPage());
            }
        });
        btn.add(ib);
        btn.add(" Goto ");
        this.m_goto = new Text<Integer>(Integer.class);
        btn.add(this.m_goto);
        this.m_goto.setMaxLength(10);
        this.m_goto.setSize(6);
        this.m_goto.setOnValueChanged(new IValueChanged<Text<Integer>>(){

            @Override
            public void onValueChanged(@Nonnull Text<Integer> component) throws Exception {
                Integer value = component.getValue();
                if (value != null) {
                    LogTailerFragment.this.gotoLine(value);
                }
            }
        });
        btn.add(" ");
        this.m_followBox = new Checkbox();
        this.m_followBox.setChecked(true);
        btn.add(" ");
        btn.add(this.m_followBox);
        btn.add("Follow ");
        this.m_followBox.setOnValueChanged(new IValueChanged<Checkbox>(){

            @Override
            public void onValueChanged(@Nonnull Checkbox component) throws Exception {
                if (component.isChecked()) {
                    LogTailerFragment.this.updateLinesPerPage();
                }
            }
        });
        ArrayList szl = new ArrayList();
        for (int size : SIZES) {
            szl.add(new ValueLabelPair<Integer>(size, Integer.toString(size)));
        }
        this.m_linesCombo = new ComboFixed(szl);
        this.m_linesCombo.setValue(32);
        this.m_linesCombo.setMandatory(true);
        this.m_linesCombo.setOnValueChanged(new IValueChanged<ComboFixed<Integer>>(){

            @Override
            public void onValueChanged(@Nonnull ComboFixed<Integer> component) throws Exception {
                LogTailerFragment.this.updateLinesPerPage();
            }
        });
        btn.add(this.m_linesCombo);
        btn.add(" lines/page");
        Div sz = new Div();
        ttl.add(sz);
        sz.setCssClass("ui-tlf-sz");
        this.m_lineSpan = new Span();
        sz.add(this.m_lineSpan);
        sz.add(" lines, ");
        this.m_szSpan = new Span();
        sz.add(this.m_szSpan);
        ttl.add(this.m_logpath);
    }

    private void gotoLine(int linenr) throws Exception {
        int maxline = this.m_task.getLastLine() - this.getLinesPerPage();
        if (maxline < 0) {
            maxline = 0;
        }
        if (linenr > maxline) {
            linenr = maxline;
        }
        if (this.m_startLine == linenr) {
            return;
        }
        if (linenr < maxline) {
            this.m_followBox.setChecked(false);
        }
        this.m_goto.setValue(null);
        this.updateLines(linenr);
    }

    private void updateSizes() {
        long sz = this.m_task.getSize();
        int ln = this.m_task.getLastLine();
        this.m_lineSpan.setText(StringTool.strCommad((long)ln));
        this.m_szSpan.setText(StringTool.strSize((long)sz));
        this.m_oldLines = ln;
        this.m_oldSize = sz;
    }

    @Override
    public void checkForChanges() throws Exception {
        int xeline;
        int xsline;
        if (this.m_noFile) {
            return;
        }
        this.m_task.readFileDelta();
        long sz = this.m_task.getSize();
        int ln = this.m_task.getLastLine();
        if (this.m_oldLines != ln || this.m_oldSize != sz) {
            this.updateSizes();
        }
        int n = xsline = this.isTailing() ? ln - this.getLinesPerPage() : this.m_startLine;
        if (xsline < 0) {
            xsline = 0;
        }
        if ((xeline = xsline + this.getLinesPerPage()) > ln) {
            xeline = ln;
        }
        int veline = this.m_startLine + this.m_lineDiv.getChildCount();
        if (xsline != this.m_startLine || xeline != veline) {
            this.updateLines(xsline);
        }
    }

    private void updateLinesPerPage() throws Exception {
        int lpp = this.getLinesPerPage();
        int cln = this.m_task.getLastLine() - lpp;
        int newln = this.m_startLine;
        if (this.isTailing()) {
            newln = cln;
        } else if (newln > cln) {
            newln = cln;
        }
        this.m_lineDiv.removeAllChildren();
        this.updateLines(newln);
    }

    private boolean isTailing() {
        return this.m_followBox.isChecked();
    }

    private void updateLines(int newstart) throws Exception {
        int maxlines;
        if (newstart < 0) {
            newstart = 0;
        }
        int vlines = this.m_lineDiv.getChildCount();
        int linesPerPage = this.getLinesPerPage();
        int xeline = newstart + linesPerPage;
        if (xeline > (maxlines = this.m_task.getLastLine())) {
            xeline = maxlines;
        }
        List<String> lines = this.m_task.getLines(newstart, xeline);
        int insix = newstart - this.m_startLine;
        if (insix <= -vlines || insix > vlines) {
            this.m_lineDiv.removeAllChildren();
            this.m_startLine = newstart;
            for (int i = 0; i < linesPerPage && i + newstart < xeline; ++i) {
                if (i >= lines.size()) {
                    throw new IllegalStateException("Attempting to get index " + i + " from lines with size " + lines.size());
                }
                NodeContainer l = this.createLine(newstart + i, lines.get(i));
                this.m_lineDiv.add(l);
            }
            return;
        }
        if (insix > 0) {
            while (insix > 0 && this.m_lineDiv.getChildCount() > 0) {
                this.m_lineDiv.getChild(0).remove();
            }
            this.m_startLine = newstart;
        } else if (insix < 0) {
            int i = 0;
            while (insix < 0) {
                String txt = lines.get(i);
                NodeContainer l = this.createLine(newstart + i, txt);
                this.m_lineDiv.add(i, l);
                ++i;
                ++insix;
            }
            this.m_startLine = newstart;
            while (this.m_lineDiv.getChildCount() > linesPerPage) {
                this.m_lineDiv.getChild(this.m_lineDiv.getChildCount() - 1).remove();
            }
        }
        for (int ix = this.m_lineDiv.getChildCount(); ix < linesPerPage && ix < lines.size(); ++ix) {
            NodeContainer l = this.createLine(newstart + ix, lines.get(ix));
            this.m_lineDiv.add(l);
        }
    }

    private NodeContainer createLine(int lnr, String txt) {
        Div line = new Div();
        line.setCssClass("ui-tlf-line");
        Span ld = new Span();
        line.add(ld);
        ld.setCssClass("ui-tlf-lnr");
        ld.setText(StringTool.strCommad((long)lnr));
        Span l = new Span();
        line.add(l);
        l.setCssClass("ui-tlf-l");
        l.setText(txt);
        return line;
    }

    private int getLinesPerPage() {
        Integer value = (Integer)this.m_linesCombo.getValue();
        if (null == value) {
            return 50;
        }
        return value;
    }
}

