/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.log.tailer;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import to.etc.domui.state.ConversationContext;
import to.etc.domui.state.IConversationStateListener;
import to.etc.util.FileTool;

public class LogTailerTask
implements IConversationStateListener {
    @Nonnull
    private final String m_logpath;
    private List<Long> m_offsetList = new ArrayList<Long>();
    private long m_currentFileSize;
    private int m_currentLinesCount;
    private RandomAccessFile m_fileContentReader;
    private FileReader m_fileDeltaReader;
    private String m_errorMsg = null;

    public LogTailerTask(@Nonnull String logpath) {
        this.m_logpath = logpath;
    }

    public boolean start() throws Exception {
        try {
            this.m_fileContentReader = new RandomAccessFile(this.m_logpath, "r");
        }
        catch (FileNotFoundException ex) {
            return false;
        }
        this.m_fileDeltaReader = new FileReader(this.m_logpath);
        this.m_currentFileSize = 0L;
        this.m_currentLinesCount = 0;
        this.m_offsetList.clear();
        this.m_offsetList.add(0L);
        this.readFileDelta();
        return true;
    }

    public synchronized int getLastLine() {
        return this.m_currentLinesCount;
    }

    public synchronized long getSize() {
        return this.m_currentFileSize;
    }

    public synchronized void readFileDelta() throws IOException {
        int item;
        int ix = 0;
        do {
            if ((item = this.m_fileDeltaReader.read()) <= -1) continue;
            ++ix;
            if (item != 10) continue;
            ++this.m_currentLinesCount;
            if (this.m_currentLinesCount % 100 != 0) continue;
            long toff = this.m_currentFileSize + (long)ix;
            this.m_offsetList.add(toff);
        } while (item > -1);
        this.m_currentFileSize += (long)ix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getLines(int first, int last) throws IOException {
        int blength;
        long boffset;
        LogTailerTask logTailerTask = this;
        synchronized (logTailerTask) {
            int ll = this.getLastLine();
            if (first >= ll) {
                return Collections.EMPTY_LIST;
            }
            if (first < 0) {
                first = 0;
            }
            if (last > ll) {
                last = ll + 1;
            }
            if (first >= last) {
                return Collections.EMPTY_LIST;
            }
            int six = first / 100;
            int eix = last / 100 + 1;
            boffset = this.m_offsetList.get(six);
            long eoffset = eix >= this.m_offsetList.size() ? this.m_currentFileSize : this.m_offsetList.get(eix);
            long l = eoffset - boffset;
            if (l > 0x100000L) {
                ArrayList<String> res = new ArrayList<String>(1);
                res.add("Puzzler viewer: lines " + first + " to " + last + " need " + l + " bytes of space to show - which is too much... Sorry...");
                return res;
            }
            blength = (int)(eoffset - boffset);
        }
        byte[] data = new byte[blength];
        this.m_fileContentReader.seek(boffset);
        int sz = this.m_fileContentReader.read(data);
        int sline = first / 100 * 100;
        int ix = 0;
        ArrayList<String> res = new ArrayList<String>(last - first);
        while (ix < sz) {
            int loff = ix;
            while (ix < sz && data[ix++] != 10) {
            }
            if (sline > last) break;
            if (sline >= first) {
                int len = ix - loff;
                if (loff >= sz || loff + len > sz) {
                    throw new IllegalStateException("Indexing overflow");
                }
                String line = new String(data, loff, len, "utf-8");
                res.add(line);
            }
            ++sline;
        }
        return res;
    }

    @Override
    public void conversationNew(@Nonnull ConversationContext cc) throws Exception {
    }

    @Override
    public void conversationAttached(@Nonnull ConversationContext cc) throws Exception {
    }

    @Override
    public void conversationDetached(@Nonnull ConversationContext cc) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void conversationDestroyed(@Nonnull ConversationContext cc) throws Exception {
        LogTailerTask logTailerTask = this;
        synchronized (logTailerTask) {
            FileTool.closeAll((Object[])new Object[]{this.m_fileContentReader, this.m_fileDeltaReader});
        }
    }
}

