/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.log.tailer;

import javax.annotation.Nonnull;
import to.etc.domui.annotations.UIUrlParameter;
import to.etc.domui.component.buttons.DefaultButton;
import to.etc.domui.component.layout.title.AppPageTitleBar;
import to.etc.domui.component.misc.InfoPanel;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.UrlPage;
import to.etc.domui.log.tailer.LogTailerFragment;
import to.etc.domui.server.IRequestContext;
import to.etc.domui.state.PageParameters;
import to.etc.domui.state.UIContext;
import to.etc.domui.state.UIGoto;

public class ServerLogPage
extends UrlPage {
    private String m_logPath;
    private String m_key;
    private static int m_ix;

    @UIUrlParameter(name="key")
    public String getKey() {
        return this.m_key;
    }

    public void setKey(String key) {
        this.m_key = key;
    }

    @Override
    public void createContent() throws Exception {
        this.add(new AppPageTitleBar("Follow a server log file", true));
        String log = (String)UIContext.getRequestContext().getSession().getAttribute(this.getKey());
        if (log == null) {
            this.add(new InfoPanel("The key for the file to access is no longer valid. Please select another file to show."));
            return;
        }
        this.add(new LogTailerFragment(log));
        this.add(new DefaultButton("Back", new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton clickednode) throws Exception {
                UIGoto.back();
            }
        }));
    }

    private static synchronized String newKey() {
        return "f" + m_ix++;
    }

    public static PageParameters createParameters(IRequestContext ctx, String path) throws Exception {
        PageParameters pp = new PageParameters();
        String key = ServerLogPage.newKey();
        ctx.getSession().setAttribute(key, path);
        pp.addParameters("key", key);
        return pp;
    }

    public static void moveSub(String path) throws Exception {
        UIGoto.moveSub(ServerLogPage.class, ServerLogPage.createParameters(UIContext.getRequestContext(), path));
    }
}

