/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.logic;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.logic.ILogiInjector;
import to.etc.domui.logic.ILogic;
import to.etc.domui.logic.ILogicContext;
import to.etc.domui.logic.errors.ProblemModel;
import to.etc.webapp.ProgrammerErrorException;
import to.etc.webapp.query.IIdentifyable;
import to.etc.webapp.query.QDataContext;

public final class LogicContextImpl
implements ILogicContext {
    @Nonnull
    private final QDataContext m_dc;
    @Nullable
    final ILogiInjector m_injector;
    @Nonnull
    private final Map<String, QDataContext> m_dataContextMap = new HashMap<String, QDataContext>();
    @Nonnull
    private final Map<Class<?>, Map<Object, ILogic>> m_instanceMap = new HashMap();
    @Nonnull
    private final Map<Class<?>, Object> m_classMap = new HashMap();
    @Nonnull
    private final List<UIMessage> m_actionMessageList = new ArrayList<UIMessage>();
    @Nonnull
    private final ProblemModel m_errorModel = new ProblemModel();

    public LogicContextImpl(@Nonnull QDataContext dataContext) {
        this.m_dataContextMap.put("default-context", dataContext);
        this.m_dc = dataContext;
        this.m_injector = null;
    }

    public LogicContextImpl(@Nonnull QDataContext dataContext, @Nonnull ILogiInjector injector) {
        this.m_dataContextMap.put("default-context", dataContext);
        this.m_dc = dataContext;
        this.m_injector = injector;
    }

    @Override
    @Nonnull
    public QDataContext dc() {
        return this.m_dc;
    }

    @Override
    @Nonnull
    public <L> L get(@Nonnull Class<L> classClass) throws Exception {
        Object logic;
        ILogiInjector ij = this.m_injector;
        if (null != ij) {
            try {
                return ij.getInstance(classClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null == (logic = this.m_classMap.get(classClass))) {
            Constructor<L> c;
            try {
                c = classClass.getConstructor(ILogicContext.class);
            }
            catch (Exception x) {
                throw new ProgrammerErrorException("Could not create an instance of " + classClass + ": constructor(ILogicContext) not found");
            }
            logic = c.newInstance(this);
            if (null == logic) {
                throw new IllegalStateException("Cobol'74 exception: no nullities defined in 2014.");
            }
            this.m_classMap.put(classClass, logic);
        }
        return (L)logic;
    }

    @Override
    @Nonnull
    public <L extends ILogic, K, T extends IIdentifyable<K>> L get(@Nonnull Class<L> clz, @Nonnull T instance) throws Exception {
        Object altkey;
        if (null == instance) {
            throw new IllegalStateException("Called with a null instance");
        }
        Map<Object, ILogic> cmap = this.m_instanceMap.get(clz);
        if (null == cmap) {
            cmap = new HashMap<Object, ILogic>();
            this.m_instanceMap.put(clz, cmap);
        }
        int ihc = System.identityHashCode(instance);
        Object key = "ihc-" + ihc;
        ILogic logic = cmap.get(key);
        if (null == logic && null != (altkey = instance.getId())) {
            logic = cmap.get(altkey);
            key = altkey;
        }
        if (null != logic) {
            return (L)logic;
        }
        L ni = this.createUsingConstructor(clz, instance);
        if (ni == null) {
            ni = this.createUsingStaticFactory(clz, instance);
        }
        if (null != ni) {
            cmap.put(key, (ILogic)ni);
            return ni;
        }
        throw new ProgrammerErrorException("Could not create an instance of " + clz + ": constructor(ILogicContext, " + instance.getClass().getName() + ") not found");
    }

    @Nullable
    private <T extends ILogic> T createUsingConstructor(@Nonnull Class<T> clz, @Nonnull Object parameterObject) throws Exception {
        for (Constructor<?> c : clz.getConstructors()) {
            Class<?>[] formalar = c.getParameterTypes();
            if (formalar.length != 2 || !formalar[0].isAssignableFrom(ILogicContext.class) || !formalar[1].isAssignableFrom(parameterObject.getClass())) continue;
            ILogic ni = (ILogic)c.newInstance(this, parameterObject);
            if (null == ni) {
                throw new IllegalStateException("Cobol'74 exception: no nullities defined in 2014.");
            }
            ILogiInjector ij = this.m_injector;
            if (null != ij) {
                ij.injectMembers(ni);
            }
            return (T)ni;
        }
        return null;
    }

    @Nullable
    private <T extends ILogic> T createUsingStaticFactory(@Nonnull Class<T> clz, @Nonnull Object parameterObject) throws Exception {
        for (Method method : clz.getMethods()) {
            if (!Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers()) || !method.getName().startsWith("create") || !clz.isAssignableFrom(method.getReturnType()) || !this.acceptParameters(method, parameterObject)) continue;
            ILogic ni = (ILogic)method.invoke(null, this, parameterObject);
            if (null == ni) {
                throw new IllegalStateException("Method " + method + " returned null instead of creating a " + clz + " from a " + parameterObject);
            }
            ILogiInjector ij = this.m_injector;
            if (null != ij) {
                ij.injectMembers(ni);
            }
            return (T)ni;
        }
        return null;
    }

    private boolean acceptParameters(Method method, Object parameterObject) {
        Class<?>[] formals = method.getParameterTypes();
        if (formals.length != 2) {
            return false;
        }
        if (!formals[0].isAssignableFrom(ILogicContext.class)) {
            return false;
        }
        return formals[1].isAssignableFrom(parameterObject.getClass());
    }

    @Override
    public <L extends ILogic> L get(@Nonnull Class<L> clz, @Nonnull Object reference) throws Exception {
        ILogic logic;
        Map<Object, ILogic> cmap = this.m_instanceMap.get(clz);
        if (null == cmap) {
            cmap = new HashMap<Object, ILogic>();
            this.m_instanceMap.put(clz, cmap);
        }
        if (null != (logic = cmap.get(reference))) {
            return (L)logic;
        }
        L ni = this.createUsingConstructor(clz, reference);
        if (ni == null) {
            ni = this.createUsingStaticFactory(clz, reference);
        }
        if (null != ni) {
            cmap.put(reference, (ILogic)ni);
            return ni;
        }
        throw new ProgrammerErrorException("Could not create an instance of " + clz + ": constructor/static factory (ILogicContext, " + reference.getClass().getName() + ") not found");
    }

    @Override
    public <T extends ILogic, K, V extends IIdentifyable<K>> void register(Class<?> registrationType, T logicClass, V dataClass) {
        Object altkey;
        Map<Object, ILogic> cmap = this.m_instanceMap.get(registrationType);
        if (null == cmap) {
            cmap = new HashMap<Object, ILogic>();
            this.m_instanceMap.put(registrationType, cmap);
        }
        int ihc = System.identityHashCode(dataClass);
        Object key = "ihc-" + ihc;
        ILogic logic = cmap.get(key);
        if (null == logic && null != (altkey = dataClass.getId())) {
            logic = cmap.get(altkey);
            key = altkey;
        }
        if (null != logic) {
            throw new ProgrammerErrorException("Duplicate registration of logic class " + registrationType.getName() + " for instance " + MetaManager.identify(dataClass));
        }
        Object id = dataClass.getId();
        if (null == id) {
            throw new IllegalStateException("You cannot register an instance having a null ID");
        }
        ILogiInjector ij = this.m_injector;
        if (null != ij) {
            ij.injectMembers(logicClass);
        }
        cmap.put(id, logicClass);
    }

    @Override
    @Nonnull
    public ProblemModel getErrorModel() {
        return this.m_errorModel;
    }
}

