/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.logic.errors;

import javax.annotation.DefaultNonNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.dom.errors.MsgType;
import to.etc.domui.logic.errors.ProblemInstance;
import to.etc.domui.logic.errors.ProblemModel;
import to.etc.webapp.nls.BundleRef;

@DefaultNonNull
@Immutable
public class Problem {
    private final BundleRef m_bundle;
    private final String m_code;
    private final String m_key;
    private final MsgType m_severity;
    private final boolean m_repeatable;

    public Problem(Class<?> anchor, String code) {
        this(anchor, code, MsgType.ERROR, false);
    }

    protected Problem(Class<?> anchor, String code, MsgType type, boolean repeatable) {
        this.m_bundle = BundleRef.create(anchor, (String)"messages");
        this.m_key = this.m_bundle.getBundleKey() + "#" + code;
        this.m_code = code;
        this.m_severity = type;
        this.m_repeatable = repeatable;
    }

    public static Problem warning(Class<?> anchor, String code) {
        return new Problem(anchor, code, MsgType.WARNING, false);
    }

    public static Problem warningList(Class<?> anchor, String code) {
        return new Problem(anchor, code, MsgType.WARNING, true);
    }

    public static Problem error(Class<?> anchor, String code) {
        return new Problem(anchor, code, MsgType.ERROR, false);
    }

    public static Problem errorList(Class<?> anchor, String code) {
        return new Problem(anchor, code, MsgType.ERROR, true);
    }

    public boolean isRepeatable() {
        return this.m_repeatable;
    }

    public String getCode() {
        return this.m_code;
    }

    public String getMessageKey() {
        return this.m_key;
    }

    public MsgType getSeverity() {
        return this.m_severity;
    }

    public BundleRef getBundle() {
        return this.m_bundle;
    }

    public <T> void off(@Nonnull ProblemModel errors, @Nonnull T instance) {
        errors.clear(this, instance, null);
    }

    public <T, P> void off(@Nonnull ProblemModel errors, @Nonnull T instance, @Nonnull PropertyMetaModel<P> property) {
        errors.clear(this, instance, property);
    }

    public <T, P> void off(@Nonnull ProblemModel errors, @Nonnull T instance, @Nonnull String property) {
        errors.clear(this, instance, MetaManager.findPropertyMeta(instance.getClass(), property));
    }

    public <T> ProblemInstance on(@Nonnull ProblemModel errors, @Nonnull T instance) {
        ProblemInstance pi = new ProblemInstance(this, instance);
        errors.addProblem(pi);
        return pi;
    }

    @Nonnull
    public <T, P> ProblemInstance on(@Nonnull ProblemModel errors, @Nonnull T instance, @Nonnull PropertyMetaModel<P> property) {
        ProblemInstance pi = new ProblemInstance(this, instance, property);
        errors.addProblem(pi);
        return pi;
    }

    @Nonnull
    public <T> ProblemInstance on(@Nonnull ProblemModel errors, @Nonnull T instance, @Nonnull String property) {
        ProblemInstance pi = new ProblemInstance(this, instance, MetaManager.getPropertyMeta(instance.getClass(), property));
        errors.addProblem(pi);
        return pi;
    }

    public <T> ProblemInstance when(@Nonnull ProblemModel errors, @Nonnull T instance, @Nonnull String property, boolean condition) {
        if (condition) {
            return this.on(errors, instance, property);
        }
        this.off(errors, instance, property);
        return new ProblemInstance(this, instance);
    }

    public <T> ProblemInstance when(@Nonnull ProblemModel errors, @Nonnull T instance, boolean condition) {
        if (condition) {
            return this.on(errors, instance);
        }
        this.off(errors, instance);
        return new ProblemInstance(this, instance);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_key == null ? 0 : this.m_key.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Problem other = (Problem)obj;
        return !(this.m_key == null ? other.m_key != null : !this.m_key.equals(other.m_key));
    }

    public String toString() {
        return (Object)((Object)this.m_severity) + " " + this.m_key;
    }
}

