/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.logic.errors;

import java.util.Arrays;
import javax.annotation.DefaultNonNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.logic.errors.Problem;

@DefaultNonNull
public final class ProblemInstance {
    private static final Object[] NONE = new Object[0];
    private final Problem m_problem;
    private final Object m_instance;
    @Nullable
    private final PropertyMetaModel<?> m_property;
    private Object[] m_parameters = NONE;
    private Object[] m_identifyingParameters = NONE;

    ProblemInstance(Problem problem, Object instance, PropertyMetaModel<?> property) {
        this.m_problem = problem;
        this.m_instance = instance;
        this.m_property = property;
    }

    ProblemInstance(Problem problem, Object instance) {
        this.m_problem = problem;
        this.m_instance = instance;
        this.m_property = null;
    }

    public Problem getProblem() {
        return this.m_problem;
    }

    public Object getInstance() {
        return this.m_instance;
    }

    @Nullable
    public PropertyMetaModel<?> getProperty() {
        return this.m_property;
    }

    public Object[] getParameters() {
        return this.m_parameters;
    }

    public void using(Object ... arguments) {
        if (this.m_parameters.length == 0) {
            this.m_parameters = arguments;
        } else if (arguments.length > 0) {
            Object[] initial = new Object[arguments.length + this.m_parameters.length];
            int index = 0;
            for (Object o : this.m_parameters) {
                initial[index++] = o;
            }
            for (Object o : arguments) {
                initial[index++] = o;
            }
            this.m_parameters = initial;
        }
        if (this.m_problem.isRepeatable()) {
            this.m_identifyingParameters = this.m_parameters;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MetaManager.identify(this.m_instance));
        PropertyMetaModel<?> pmm = this.m_property;
        if (null != pmm) {
            sb.append(".").append(pmm.getName());
        }
        sb.append(' ');
        sb.append(this.m_problem.toString());
        return sb.toString();
    }

    @Nonnull
    public String getMessage() {
        return this.getProblem().getBundle().formatMessage(this.getProblem().getCode(), this.getParameters());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProblemInstance that = (ProblemInstance)o;
        if (!this.m_problem.equals(that.m_problem)) {
            return false;
        }
        if (!this.m_instance.equals(that.m_instance)) {
            return false;
        }
        if (this.m_property != null ? !this.m_property.equals(that.m_property) : that.m_property != null) {
            return false;
        }
        return Arrays.equals(this.m_identifyingParameters, that.m_identifyingParameters);
    }

    public int hashCode() {
        int result = this.m_problem.hashCode();
        result = 31 * result + this.m_instance.hashCode();
        result = 31 * result + (this.m_property != null ? this.m_property.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.m_identifyingParameters);
        return result;
    }
}

