/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.logic.errors;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.dom.errors.MsgType;
import to.etc.domui.logic.errors.Problem;
import to.etc.domui.logic.errors.ProblemInstance;
import to.etc.domui.logic.errors.ProblemSet;

public class ProblemModel {
    @Nullable
    private final ProblemModel m_parent = null;
    @Nonnull
    private Map<Object, Map<PropertyMetaModel<?>, Set<ProblemInstance>>> m_map = new HashMap();

    void addProblem(@Nonnull ProblemInstance problem) {
        Set<ProblemInstance> messages;
        Map<PropertyMetaModel<?>, Set<ProblemInstance>> mapOnProp = this.m_map.get(problem.getInstance());
        if (mapOnProp == null) {
            mapOnProp = new HashMap();
            this.m_map.put(problem.getInstance(), mapOnProp);
        }
        if ((messages = mapOnProp.get(problem.getProperty())) == null) {
            messages = new HashSet<ProblemInstance>();
            mapOnProp.put(problem.getProperty(), messages);
        }
        messages.add(problem);
    }

    public void clear() {
        this.m_map.clear();
    }

    <T, P> void clear(@Nonnull Problem problem, @Nonnull T instance, @Nullable PropertyMetaModel<P> pmm) {
        Set<ProblemInstance> messages;
        Map<PropertyMetaModel<?>, Set<ProblemInstance>> mapOnProp = this.m_map.get(instance);
        if (mapOnProp != null && (messages = mapOnProp.get(pmm)) != null) {
            for (ProblemInstance pi : messages) {
                if (!pi.getProblem().equals(problem)) continue;
                messages.remove(pi);
                return;
            }
        }
    }

    @Nonnull
    public <T> Set<ProblemInstance> getErrorsOn(@Nonnull T businessObject) {
        return this.getErrorsOn(businessObject, (PropertyMetaModel)null);
    }

    public <T> Set<ProblemInstance> getAllErrorsOn(@Nonnull T businessObject) {
        HashSet<ProblemInstance> res = new HashSet<ProblemInstance>();
        Map<PropertyMetaModel<?>, Set<ProblemInstance>> mapOnProp = this.m_map.get(businessObject);
        if (mapOnProp != null) {
            for (Set<ProblemInstance> pset : mapOnProp.values()) {
                res.addAll(pset);
            }
        }
        return res;
    }

    @Nonnull
    public <T, V> Set<ProblemInstance> getErrorsOn(@Nonnull T businessObject, @Nullable PropertyMetaModel<V> property) {
        Set<ProblemInstance> messagesList;
        Map<PropertyMetaModel<?>, Set<ProblemInstance>> mapOnProp = this.m_map.get(businessObject);
        if (mapOnProp != null && (messagesList = mapOnProp.get(property)) != null) {
            return messagesList;
        }
        return Collections.EMPTY_SET;
    }

    @Nonnull
    public <T> Set<ProblemInstance> getErrorsOn(@Nonnull T businessObject, @Nonnull String property) {
        return this.getErrorsOn(businessObject, MetaManager.getPropertyMeta(businessObject.getClass(), property));
    }

    public boolean hasWarnings() {
        return this.hasMsgType(MsgType.WARNING);
    }

    public boolean hasErrors() {
        return this.hasMsgType(MsgType.ERROR);
    }

    private boolean hasMsgType(MsgType msgType) {
        for (Map<PropertyMetaModel<?>, Set<ProblemInstance>> m1 : this.m_map.values()) {
            for (Set<ProblemInstance> set : m1.values()) {
                for (ProblemInstance instance : set) {
                    if (!msgType.equals((Object)instance.getProblem().getSeverity())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Nonnull
    public ProblemSet getErrorSet() {
        return new ProblemSet(this.m_map);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map<PropertyMetaModel<?>, Set<ProblemInstance>> map : this.m_map.values()) {
            for (Set<ProblemInstance> piSet : map.values()) {
                for (ProblemInstance pi : piSet) {
                    if (sb.length() != 0) {
                        sb.append('\n');
                    }
                    sb.append(pi.getProblem()).append(" @");
                    PropertyMetaModel<?> pmm = pi.getProperty();
                    if (null != pmm) {
                        sb.append(pmm.getName()).append("/");
                    }
                    sb.append(MetaManager.identify(pi.getInstance()));
                }
            }
        }
        return sb.toString();
    }
}

