/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.logic.errors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.binding.ComponentPropertyBinding;
import to.etc.domui.component.binding.IBinding;
import to.etc.domui.dom.errors.IErrorFence;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.logic.errors.ProblemInstance;
import to.etc.domui.logic.errors.ProblemModel;
import to.etc.domui.logic.errors.ProblemSet;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.IValueAccessor;

public class ProblemReporter {
    private static final boolean DEBUG = false;
    private final NodeBase m_rootNode;
    private final ProblemModel m_model;
    private static final Comparator<ProblemInstance> C_BYSEVERITY = new Comparator<ProblemInstance>(){

        @Override
        public int compare(@Nullable ProblemInstance a, @Nullable ProblemInstance b) {
            if (a == null || b == null) {
                throw new IllegalStateException();
            }
            int rc = b.getProblem().getSeverity().getOrder() - a.getProblem().getSeverity().getOrder();
            if (rc != 0) {
                return rc;
            }
            return a.getProblem().getMessageKey().compareTo(b.getProblem().getMessageKey());
        }
    };

    public ProblemReporter(NodeBase root, ProblemModel model) {
        this.m_rootNode = root;
        this.m_model = model;
    }

    @Nonnull
    private Set<IErrorFence> getAllFences() throws Exception {
        final HashSet<IErrorFence> res = new HashSet<IErrorFence>();
        DomUtil.walkTree(this.m_rootNode, new DomUtil.IPerNode(){

            @Override
            @Nullable
            public Object before(NodeBase n) throws Exception {
                NodeContainer nc;
                IErrorFence fence;
                if (n instanceof NodeContainer && null != (fence = (nc = (NodeContainer)n).getErrorFence())) {
                    res.add(fence);
                }
                return null;
            }

            @Override
            @Nullable
            public Object after(NodeBase n) throws Exception {
                return null;
            }
        });
        return res;
    }

    @Nonnull
    private Set<UIMessage> getAllErrorSet(@Nonnull Collection<IErrorFence> fenceList) {
        HashSet<UIMessage> res = new HashSet<UIMessage>();
        for (IErrorFence f : fenceList) {
            res.addAll(f.getMessageList());
        }
        return res;
    }

    public void report() throws Exception {
        Set<IErrorFence> allFences = this.getAllFences();
        Set<UIMessage> existingErrorSet = this.getAllErrorSet(allFences);
        ProblemSet newErrorSet = this.m_model.getErrorSet();
        final ArrayList bindableNodes = new ArrayList();
        DomUtil.walkTree(this.m_rootNode, new DomUtil.IPerNode(){

            @Override
            @Nullable
            public Object before(NodeBase n) throws Exception {
                List<IBinding> bindingList = n.getBindingList();
                if (null != bindingList && bindingList.size() > 0) {
                    bindableNodes.add(n);
                }
                return null;
            }

            @Override
            @Nullable
            public Object after(NodeBase n) throws Exception {
                return null;
            }
        });
        for (NodeBase n : bindableNodes) {
            this.handleClaimError(existingErrorSet, newErrorSet, n);
        }
        for (ProblemInstance pi : newErrorSet) {
            if (this.inExistingSet(existingErrorSet, null, pi)) continue;
            UIMessage ui = UIMessage.create(null, pi);
            this.m_rootNode.addGlobalMessage(ui);
        }
        for (UIMessage old : existingErrorSet) {
            for (IErrorFence f : allFences) {
                if ("BindingError" == old.getGroup()) continue;
                f.removeMessage(old);
            }
        }
    }

    private void handleClaimError(Set<UIMessage> existingErrorSet, ProblemSet newErrorSet, @Nonnull NodeBase n) {
        List<IBinding> bindingList = n.getBindingList();
        if (null == bindingList) {
            return;
        }
        ArrayList<ProblemInstance> all = new ArrayList<ProblemInstance>();
        ArrayList<UIMessage> bindingMessageList = new ArrayList<UIMessage>();
        for (IBinding binding : bindingList) {
            if (!(binding instanceof ComponentPropertyBinding)) continue;
            ComponentPropertyBinding sib = (ComponentPropertyBinding)binding;
            this.getErrorsOnBoundProperty(newErrorSet, all, n, sib);
            UIMessage be = binding.getBindError();
            if (null == be) continue;
            bindingMessageList.add(be);
        }
        if (all.size() == 0) {
            if (bindingMessageList.size() == 0) {
                n.setMessage(null);
            }
            return;
        }
        Collections.sort(all, C_BYSEVERITY);
        IErrorFence fence = DomUtil.getMessageFence(n);
        for (ProblemInstance pi : all) {
            if (this.inExistingSet(existingErrorSet, n, pi)) continue;
            UIMessage ui = UIMessage.create(n, pi);
            n.setMessage(ui);
            fence.addMessage(ui);
        }
    }

    private static String desc(NodeBase n) {
        return "'" + n.getComponentInfo() + "' (" + n.getActualID() + ")";
    }

    private boolean inExistingSet(Set<UIMessage> existingErrorSet, @Nullable NodeBase node, ProblemInstance pi) {
        for (UIMessage m : existingErrorSet) {
            if (node != m.getErrorNode() || !m.getMessageKey().equals(pi.getProblem().getMessageKey()) || !Arrays.equals(m.getParameters(), pi.getParameters())) continue;
            existingErrorSet.remove(m);
            return true;
        }
        return false;
    }

    private void getErrorsOnBoundProperty(ProblemSet newErrorSet, @Nonnull List<ProblemInstance> all, @Nonnull NodeBase n, @Nonnull ComponentPropertyBinding binding) {
        Object instance = binding.getInstance();
        if (null == instance) {
            return;
        }
        IValueAccessor<?> property = binding.getInstanceProperty();
        if (null == property) {
            return;
        }
        Set<ProblemInstance> errors = newErrorSet.remove(instance, property);
        all.addAll(errors);
    }
}

