/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.logic.errors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.logic.errors.ProblemInstance;
import to.etc.domui.util.IValueAccessor;

public final class ProblemSet
implements Iterable<ProblemInstance> {
    @Nonnull
    private final Map<Object, Map<IValueAccessor<?>, Set<ProblemInstance>>> m_map = new HashMap();

    ProblemSet(@Nonnull Map<Object, Map<PropertyMetaModel<?>, Set<ProblemInstance>>> map) {
        for (Map.Entry<Object, Map<PropertyMetaModel<?>, Set<ProblemInstance>>> m1 : map.entrySet()) {
            for (Map.Entry<PropertyMetaModel<?>, Set<ProblemInstance>> m2 : m1.getValue().entrySet()) {
                for (ProblemInstance m : m2.getValue()) {
                    Set<ProblemInstance> errSet;
                    Map<IValueAccessor<?>, Set<ProblemInstance>> objectMap = this.m_map.get(m1.getKey());
                    if (null == objectMap) {
                        objectMap = new HashMap();
                        this.m_map.put(m1.getKey(), objectMap);
                    }
                    if (null == (errSet = objectMap.get(m2.getKey()))) {
                        errSet = new HashSet<ProblemInstance>();
                        objectMap.put(m2.getKey(), errSet);
                    }
                    errSet.add(m);
                }
            }
        }
    }

    @Nonnull
    public List<ProblemInstance> getErrorList() {
        ArrayList<ProblemInstance> res = new ArrayList<ProblemInstance>();
        for (Map.Entry<Object, Map<IValueAccessor<?>, Set<ProblemInstance>>> m1 : this.m_map.entrySet()) {
            for (Map.Entry<IValueAccessor<?>, Set<ProblemInstance>> m2 : m1.getValue().entrySet()) {
                res.addAll((Collection<ProblemInstance>)m2.getValue());
            }
        }
        return res;
    }

    @Override
    @Nonnull
    public Iterator<ProblemInstance> iterator() {
        return this.getErrorList().iterator();
    }

    public Set<ProblemInstance> remove(@Nonnull Object instance, @Nullable IValueAccessor<?> property) {
        Set<ProblemInstance> set;
        Map<IValueAccessor<?>, Set<ProblemInstance>> objectMap = this.m_map.get(instance);
        if (null != objectMap && null != (set = objectMap.remove(property))) {
            return set;
        }
        return Collections.EMPTY_SET;
    }
}

