/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.logic.events;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.logic.events.LogiEventBase;
import to.etc.domui.logic.events.LogiEventPropertyChange;
import to.etc.webapp.eventmanager.ChangeType;

public final class LogiEventInstanceChange
extends LogiEventBase {
    @Nonnull
    private final Object m_instance;
    @Nonnull
    private final ChangeType m_type;
    @Nonnull
    private final Map<String, LogiEventPropertyChange<?>> m_propertyChangeMap = new HashMap();

    public LogiEventInstanceChange(@Nonnull ChangeType type, @Nonnull String path, @Nonnull Object instance) {
        super(path);
        this.m_instance = instance;
        this.m_type = type;
    }

    public <P> void addChange(@Nonnull LogiEventPropertyChange<P> pc) {
        this.m_propertyChangeMap.put(pc.getPmm().getName(), pc);
    }

    @Nonnull
    public Object getInstance() {
        return this.m_instance;
    }

    public boolean isPropertyChanged(@Nonnull String propertyName) {
        return this.m_propertyChangeMap.containsKey(propertyName);
    }

    public <T> boolean isPropertyChanged(@Nonnull PropertyMetaModel<T> pmm) {
        return this.m_propertyChangeMap.containsKey(pmm.getName());
    }

    @Nullable
    public LogiEventPropertyChange<?> findPropertyChange(String propertyName) {
        return this.m_propertyChangeMap.get(propertyName);
    }

    @Nullable
    public <T> LogiEventPropertyChange<T> findPropertyChange(@Nonnull PropertyMetaModel<T> pmm) {
        return this.m_propertyChangeMap.get(pmm.getName());
    }

    @Override
    void dump(@Nonnull Appendable a) throws Exception {
        a.append(this.getPath());
        a.append(" [instance ").append(MetaManager.identify(this.m_instance)).append(" ").append(this.m_type.toString()).append(" ").append(Integer.toString(this.m_propertyChangeMap.size())).append(" properties]\n");
    }
}

