/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.logic.events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.logic.events.ListDeltaType;
import to.etc.domui.logic.events.LogiEvent;
import to.etc.domui.logic.events.LogiEventBase;
import to.etc.domui.logic.events.LogiEventInstanceChange;
import to.etc.domui.logic.events.LogiEventListDelta;
import to.etc.domui.logic.events.LogiEventPropertyChange;
import to.etc.webapp.eventmanager.ChangeType;

public class LogiEventSet {
    private StringBuilder m_path_sb = new StringBuilder();
    private int[] m_pathIndices_ar = new int[128];
    private int m_pathIndex;
    @Nonnull
    private final List<LogiEventBase> m_allEvents = new ArrayList<LogiEventBase>();
    @Nonnull
    private final Map<Object, LogiEventInstanceChange> m_instanceEventMap = new HashMap<Object, LogiEventInstanceChange>();

    public void addRootInstanceRemoved(@Nonnull Object root, @Nonnull Object rootCopy) {
    }

    public void addRootInstanceAdded(@Nonnull Object root) {
        this.getInstance(ChangeType.ADDED, root);
    }

    @Nonnull
    private LogiEventInstanceChange getInstance(@Nonnull ChangeType ct, @Nonnull Object inst) {
        LogiEventInstanceChange ic = this.m_instanceEventMap.get(inst);
        if (null == ic) {
            ic = new LogiEventInstanceChange(ct, this.m_path_sb.toString(), inst);
            this.m_instanceEventMap.put(inst, ic);
            this.m_allEvents.add(ic);
        }
        return ic;
    }

    public <T, P> void propertyChange(@Nonnull PropertyMetaModel<P> pmm, @Nonnull T source, @Nullable T copy, @Nullable P sourceval, @Nullable P copyval) {
        LogiEventInstanceChange ic = this.getInstance(ChangeType.MODIFIED, source);
        this.enter();
        this.appendPath(pmm.getName());
        LogiEventPropertyChange<P> pc = new LogiEventPropertyChange<P>(this.m_path_sb.toString(), pmm, copyval, sourceval);
        ic.addChange(pc);
        this.m_allEvents.add(pc);
        this.leave();
    }

    public <T, P> void addCollectionClear(@Nonnull PropertyMetaModel<P> pmm, @Nonnull T source, @Nullable T copy, @Nullable P sourceval, @Nullable P copyval) {
        this.enter();
        this.appendPath(pmm.getName());
        LogiEventListDelta<T, P, Object> ld = new LogiEventListDelta<T, P, Object>(this.m_path_sb.toString(), source, pmm, -1, null, ListDeltaType.CLEAR);
        this.m_allEvents.add(ld);
        this.leave();
    }

    public <T, P> void addCollectionDelete(@Nonnull PropertyMetaModel<P> pmm, @Nonnull T source, @Nullable T copy, int collectionIndex, @Nullable Object sourceCollectionInstanceEntry) {
        this.enter();
        this.appendPath(pmm.getName());
        LogiEventListDelta<T, P, Object> ld = new LogiEventListDelta<T, P, Object>(this.m_path_sb.toString(), source, pmm, collectionIndex, sourceCollectionInstanceEntry, ListDeltaType.DELETE);
        this.m_allEvents.add(ld);
        this.leave();
    }

    public <T, P> void addCollectionAdd(@Nonnull PropertyMetaModel<P> pmm, @Nonnull T source, @Nullable T copy, int collectionIndex, @Nullable Object sourceCollectionInstanceEntry) {
        this.enter();
        this.appendPath(pmm.getName());
        LogiEventListDelta<T, P, Object> ld = new LogiEventListDelta<T, P, Object>(this.m_path_sb.toString(), source, pmm, collectionIndex, sourceCollectionInstanceEntry, ListDeltaType.INSERT);
        this.m_allEvents.add(ld);
        this.leave();
    }

    public void enterRoot(int rix) {
        this.enter();
        this.appendPath("root[" + rix + "]");
    }

    private void enter() {
        ++this.m_pathIndex;
        if (this.m_pathIndex >= this.m_pathIndices_ar.length) {
            int[] nw = new int[this.m_pathIndex + 128];
            System.arraycopy(this.m_pathIndices_ar, 0, nw, 0, this.m_pathIndices_ar.length);
            this.m_pathIndices_ar = nw;
        }
        this.m_pathIndices_ar[this.m_pathIndex] = this.m_path_sb.length();
    }

    private void appendPath(String s) {
        this.m_path_sb.setLength(this.m_pathIndices_ar[this.m_pathIndex]);
        if (this.m_pathIndex > 1) {
            this.m_path_sb.append("/");
        }
        this.m_path_sb.append(s);
    }

    private void leave() {
        --this.m_pathIndex;
        if (this.m_pathIndex < 0) {
            throw new IllegalStateException("Underflow??");
        }
        this.m_path_sb.setLength(this.m_pathIndices_ar[this.m_pathIndex]);
    }

    public void exitRoot(int rix) {
        this.leave();
    }

    protected void dump(@Nonnull Appendable a) throws Exception {
        a.append("eventSet[\n");
        for (LogiEventBase lb : this.m_allEvents) {
            lb.dump(a);
        }
        a.append("]");
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            this.dump(sb);
            return sb.toString();
        }
        catch (Exception x) {
            return x.toString();
        }
    }

    public LogiEvent createEvent() {
        return new LogiEvent(this.m_allEvents, this.m_instanceEventMap);
    }
}

