/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.login;

import javax.annotation.Nonnull;
import to.etc.domui.component.layout.CaptionedPanel;
import to.etc.domui.component.misc.ALink;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.Img;
import to.etc.domui.dom.html.Li;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.Table;
import to.etc.domui.dom.html.Ul;
import to.etc.domui.dom.html.UrlPage;
import to.etc.domui.server.DomApplication;
import to.etc.domui.state.MoveMode;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.Msgs;

public class AccessDeniedPage
extends UrlPage {
    public static final String PARAM_REFUSAL_MSG = "refusalMsg";
    public static final String PARAM_TARGET_PAGE = "targetPage";

    @Override
    public void createContent() throws Exception {
        String cname = this.getPage().getPageParameters().getString(PARAM_TARGET_PAGE);
        String pageName = "...";
        if (cname != null) {
            Class<? extends UrlPage> clz = null;
            try {
                clz = DomApplication.get().loadPageClass(cname);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (clz == null) {
                pageName = cname;
            } else {
                String s = DomUtil.calcPageTitle(clz);
                if (s == null) {
                    s = DomUtil.calcPageLabel(clz);
                }
                if (s != null) {
                    pageName = s;
                }
            }
        }
        CaptionedPanel ep = new CaptionedPanel(Msgs.BUNDLE.getString("login.access.title"));
        this.add(ep);
        Table t = new Table();
        t.addCssClass("ui-acd-tbl");
        ep.getContent().add(t);
        TBody b = t.addBody();
        TD td = b.addRowAndCell();
        Img img = new Img("THEME/accessDenied.png");
        td.add(img);
        TD co = b.addCell();
        String txt = Msgs.BUNDLE.formatMessage("login.access.denied", new Object[]{pageName});
        Div d = new Div("ui-acd-ttl");
        co.add(d);
        d.setText(txt);
        if (this.getPage().getPageParameters().hasParameter(PARAM_REFUSAL_MSG)) {
            d = new Div();
            co.add(d);
            d.setText(Msgs.BUNDLE.formatMessage("login.refusal.reason", new Object[0]));
            d = new Div();
            co.add(d);
            Ul ul = new Ul();
            d.add(ul);
            Li li = new Li();
            ul.add(li);
            li.add(this.getPage().getPageParameters().getString(PARAM_REFUSAL_MSG));
        } else {
            d = new Div();
            d.setText(Msgs.BUNDLE.formatMessage("login.required.rights", new Object[0]));
            co.add(d);
            d = new Div();
            co.add(d);
            this.renderMissingRightsInfo(d);
        }
        if (DomApplication.get().getRootPage() != null) {
            d = new Div();
            co.add(d);
            ALink link = new ALink(DomApplication.get().getRootPage(), MoveMode.NEW);
            d.add(link);
            link.setText(Msgs.BUNDLE.getString("login.toindex"));
        }
    }

    protected void renderMissingRightsInfo(@Nonnull Div d) {
        String r;
        Ul ul = new Ul();
        d.add(ul);
        for (int i = 0; i < 99 && (r = this.getPage().getPageParameters().getString("r" + i, null)) != null; ++i) {
            Li li = new Li();
            ul.add(li);
            String desc = DomApplication.get().getRightsDescription(r);
            li.add(desc + " (" + r + ")");
        }
    }
}

