/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.pages.generic;

import javax.annotation.Nonnull;
import to.etc.domui.component.buttons.DefaultButton;
import to.etc.domui.component.controlfactory.ModelBindings;
import to.etc.domui.component.form.TabularFormBuilder;
import to.etc.domui.component.layout.ButtonBar;
import to.etc.domui.component.layout.IButtonBar;
import to.etc.domui.component.layout.Panel;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.pages.generic.BasicPage;
import to.etc.domui.state.UIGoto;
import to.etc.webapp.query.QDataContext;

public abstract class BasicEditPage<T>
extends BasicPage<T> {
    private IButtonBar m_buttonBar;
    private boolean m_deleteable;
    private boolean m_displayonly;
    private TabularFormBuilder m_formBuilder;
    private ModelBindings m_bindings;

    public abstract T getInstance() throws Exception;

    public BasicEditPage(Class<T> valueClass) {
        this(valueClass, false);
    }

    public BasicEditPage(Class<T> valueClass, boolean deleteable) {
        super(valueClass);
        this.m_deleteable = deleteable;
    }

    public TabularFormBuilder getBuilder() throws Exception {
        if (this.m_formBuilder == null) {
            this.m_formBuilder = new TabularFormBuilder(this.getInstance());
        }
        return this.m_formBuilder;
    }

    @Override
    public final void createContent() throws Exception {
        if (this.m_formBuilder != null) {
            this.m_formBuilder.reset();
        }
        this.m_buttonBar = null;
        super.createContent();
        if (!this.onBeforeCreateContent()) {
            return;
        }
        this.createButtonBar();
        this.createButtons();
        this.createEditableBase();
        this.onAfterCreateContent();
    }

    protected boolean onBeforeCreateContent() throws Exception {
        return true;
    }

    protected void onAfterCreateContent() throws Exception {
    }

    private void createEditableBase() throws Exception {
        NodeContainer nc;
        this.m_bindings = this.createEditable();
        if (this.m_formBuilder != null && (nc = this.m_formBuilder.finish()) != null) {
            Panel p = new Panel();
            this.add(p);
            p.add(nc);
            if (this.m_bindings == null) {
                this.m_bindings = this.m_formBuilder.getBindings();
            }
        }
        if (this.m_bindings != null) {
            this.m_bindings.moveModelToControl();
        }
    }

    protected ModelBindings createEditable() throws Exception {
        return null;
    }

    protected void createButtonBar() {
        this.add((ButtonBar)this.getButtonBar());
    }

    public IButtonBar getButtonBar() {
        if (this.m_buttonBar == null) {
            this.m_buttonBar = new ButtonBar();
        }
        return this.m_buttonBar;
    }

    public boolean isDeleteable() {
        return this.m_deleteable;
    }

    protected void createButtons() {
        if (!this.isDisplayonly()) {
            this.createCommitButton();
            this.createCancelButton();
            if (this.isDeleteable()) {
                this.createDeleteButton();
            }
        }
    }

    protected void createCommitButton() {
        this.getButtonBar().addButton("C!ommit", "THEME/btnSave.png", new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton b) throws Exception {
                BasicEditPage.this.save();
            }
        });
    }

    protected void createCancelButton() {
        this.getButtonBar().addButton("!Cancel", "THEME/btnCancel.png", new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton b) throws Exception {
                BasicEditPage.this.cancel();
            }
        });
    }

    protected void createDeleteButton() {
        this.getButtonBar().addConfirmedButton("!Delete", "THEME/btnDelete.png", "Delete: are you sure?", new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton b) throws Exception {
                BasicEditPage.this.delete();
            }
        });
    }

    @Override
    public String getPageTitle() {
        ClassMetaModel cmm = MetaManager.findClassMeta(this.getBaseClass());
        String name = cmm.getUserEntityName();
        if (name != null) {
            return name;
        }
        return this.getBaseClass().getName().substring(this.getBaseClass().getName().lastIndexOf(46) + 1);
    }

    protected void save() throws Exception {
        if (this.getBindings() != null) {
            this.getBindings().moveControlToModel();
        }
        if (!this.validate()) {
            return;
        }
        this.onSave(this.getInstance());
        this.onAfterSave();
    }

    protected void onAfterSave() {
        UIGoto.back();
    }

    protected boolean validate() throws Exception {
        return true;
    }

    protected void cancel() throws Exception {
        UIGoto.back();
    }

    protected void delete() throws Exception {
        if (this.onDelete(this.getInstance())) {
            UIGoto.back();
        }
    }

    public boolean isDisplayonly() {
        return this.m_displayonly;
    }

    public void setDisplayonly(boolean displayonly) {
        if (this.m_displayonly == displayonly) {
            return;
        }
        this.m_displayonly = displayonly;
        this.forceRebuild();
    }

    public ModelBindings getBindings() {
        return this.m_bindings;
    }

    protected void onSave(@Nonnull T object) throws Exception {
        QDataContext dc = this.getSharedContext();
        dc.startTransaction();
        this.saveObject(dc, object);
        dc.commit();
    }

    protected void saveObject(@Nonnull QDataContext dc, @Nonnull T object) throws Exception {
        dc.save(object);
    }

    protected boolean onDelete(@Nonnull T object) throws Exception {
        QDataContext dc = this.getSharedContext();
        dc.startTransaction();
        boolean res = this.deleteObject(dc, object);
        dc.commit();
        return res;
    }

    protected boolean deleteObject(@Nonnull QDataContext dc, @Nonnull T object) throws Exception {
        dc.delete(object);
        return true;
    }
}

