/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.pages.generic;

import javax.annotation.Nonnull;
import to.etc.domui.component.lookup.LookupForm;
import to.etc.domui.component.tbl.AbstractRowRenderer;
import to.etc.domui.component.tbl.BasicRowRenderer;
import to.etc.domui.component.tbl.DataPager;
import to.etc.domui.component.tbl.DataTable;
import to.etc.domui.component.tbl.ICellClicked;
import to.etc.domui.component.tbl.IClickableRowRenderer;
import to.etc.domui.component.tbl.IQueryHandler;
import to.etc.domui.component.tbl.IRowRenderer;
import to.etc.domui.component.tbl.SimpleSearchModel;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.pages.generic.BasicPage;
import to.etc.domui.util.Msgs;
import to.etc.webapp.query.IQContextContainer;
import to.etc.webapp.query.QContextManager;
import to.etc.webapp.query.QCriteria;
import to.etc.webapp.query.QDataContextFactory;

public abstract class BasicListPage<T>
extends BasicPage<T> {
    private LookupForm<T> m_lookupForm;
    private DataTable<T> m_result;
    private DataPager m_pager;
    private boolean m_allowEmptySearch;
    private boolean m_searchImmediately;
    private IQueryHandler<T> m_queryHandler;
    private IRowRenderer<T> m_rowRenderer;

    public abstract void onSelect(@Nonnull T var1) throws Exception;

    protected abstract void onNew() throws Exception;

    public BasicListPage(Class<T> clz) {
        super(clz);
    }

    public BasicListPage(Class<T> baseClass, String txt) {
        super(baseClass, txt);
    }

    protected void customizeLookupForm(@Nonnull LookupForm<T> lf) throws Exception {
    }

    @Override
    public void createContent() throws Exception {
        super.createContent();
        this.m_lookupForm = new LookupForm(this.getBaseClass(), new String[0]);
        this.add(this.m_lookupForm);
        this.m_lookupForm.setClicked(new IClicked<LookupForm<T>>(){

            @Override
            public void clicked(@Nonnull LookupForm<T> b) throws Exception {
                BasicListPage.this.search(b);
            }
        });
        if (this.hasEditRight()) {
            this.m_lookupForm.setOnNew(new IClicked<LookupForm<T>>(){

                @Override
                public void clicked(@Nonnull LookupForm<T> b) throws Exception {
                    BasicListPage.this.onNew();
                }
            });
        }
        this.m_lookupForm.setOnClear(new IClicked<LookupForm<T>>(){

            @Override
            public void clicked(@Nonnull LookupForm<T> b) throws Exception {
                BasicListPage.this.onLookupFormClear(b);
            }
        });
        this.customizeLookupForm(this.m_lookupForm);
        if (this.m_result != null) {
            this.add(this.m_result);
            this.add(this.m_pager);
        }
        if (this.isSearchImmediately()) {
            this.search(this.m_lookupForm);
        }
    }

    void search(LookupForm<T> lf) throws Exception {
        QCriteria<T> c = lf.getEnteredCriteria();
        if (c == null) {
            return;
        }
        this.clearGlobalMessage("v.missing.search");
        if (!lf.hasUserDefinedCriteria() && !this.isAllowEmptySearch()) {
            this.addGlobalMessage(UIMessage.error(Msgs.BUNDLE, "v.missing.search", new Object[0]));
            return;
        }
        this.clearGlobalMessage();
        this.setTableQuery(c);
    }

    protected void adjustCriteria(@Nonnull QCriteria<T> crit) {
    }

    private void setTableQuery(QCriteria<T> qc) throws Exception {
        SimpleSearchModel<T> model;
        this.adjustCriteria(qc);
        if (this.m_queryHandler == null) {
            QDataContextFactory src = QContextManager.getDataContextFactory((String)"default-context", (IQContextContainer)this.getPage());
            model = new SimpleSearchModel<T>(src, qc);
        } else {
            model = new SimpleSearchModel<T>(this.m_queryHandler, qc);
        }
        if (this.m_result == null) {
            IClickableRowRenderer arrh;
            IRowRenderer<T> renderer = this.getRowRenderer();
            if (renderer instanceof IClickableRowRenderer && (arrh = (IClickableRowRenderer)renderer).getRowClicked() == null) {
                arrh.setRowClicked(new ICellClicked<T>(){

                    @Override
                    public void cellClicked(@Nonnull NodeBase tr, @Nonnull T val) throws Exception {
                        BasicListPage.this.onSelect(val);
                    }
                });
            }
            this.m_result = new DataTable<T>(model, renderer);
            this.add(this.m_result);
            this.m_result.setPageSize(35);
            this.m_result.setTableWidth("100%");
            this.m_result.setTestID("resultBasicVpListPage");
            this.m_pager = new DataPager(this.m_result);
            this.add(this.m_pager);
            this.m_pager.setTestID("pagerBasicVpListPage");
        } else {
            this.m_result.setModel(model);
        }
    }

    @Override
    protected void onShelve() throws Exception {
        this.resetAllSharedContexts();
    }

    protected void onLookupFormClear(LookupForm<T> lf) throws Exception {
    }

    public IRowRenderer<T> getRowRenderer() throws Exception {
        AbstractRowRenderer arrh;
        if (this.m_rowRenderer == null) {
            this.m_rowRenderer = new BasicRowRenderer(this.getBaseClass(), new Object[0]);
        }
        if (this.m_rowRenderer instanceof AbstractRowRenderer && (arrh = (AbstractRowRenderer)this.m_rowRenderer).getRowClicked() == null) {
            arrh.setRowClicked(new ICellClicked<T>(){

                @Override
                public void cellClicked(@Nonnull NodeBase tr, @Nonnull T val) throws Exception {
                    BasicListPage.this.onSelect(val);
                }
            });
        }
        return this.m_rowRenderer;
    }

    public void setRowRenderer(IRowRenderer<T> rr) {
        this.m_rowRenderer = rr;
    }

    public boolean isSearchImmediately() {
        return this.m_searchImmediately;
    }

    public void setSearchImmediately(boolean searchImmediately) {
        this.m_searchImmediately = searchImmediately;
    }

    public boolean isAllowEmptySearch() {
        return this.m_allowEmptySearch;
    }

    public void setAllowEmptySearch(boolean allowEmptySearch) {
        this.m_allowEmptySearch = allowEmptySearch;
    }

    public boolean hasEditRight() {
        return true;
    }

    protected LookupForm<T> getLookupForm() {
        return this.m_lookupForm;
    }

    protected void setLookupForm(LookupForm<T> lookupForm) {
        this.m_lookupForm = lookupForm;
    }

    protected IQueryHandler<T> getQueryHandler() {
        return this.m_queryHandler;
    }

    protected void setQueryHandler(IQueryHandler<T> queryHandler) {
        this.m_queryHandler = queryHandler;
    }
}

