/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.pages.generic;

import to.etc.domui.component.layout.title.BasePageTitleBar;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.dom.errors.IErrorFence;
import to.etc.domui.dom.html.UrlPage;
import to.etc.domui.server.DomApplication;
import to.etc.domui.util.DomUtil;
import to.etc.webapp.nls.BundleRef;

public class BasicPage<T>
extends UrlPage {
    private Class<T> m_baseClass;
    private BasePageTitleBar m_titleBar;

    public BasicPage(Class<T> baseClass) {
        this.m_baseClass = baseClass;
    }

    public BasicPage(Class<T> baseClass, String txt) {
        this.m_baseClass = baseClass;
        this.setPageTitle(txt);
    }

    public Class<T> getBaseClass() {
        return this.m_baseClass;
    }

    @Override
    public void createContent() throws Exception {
        this.addPageHeaders();
        this.addPageTitleBar();
    }

    @Override
    public void setPageTitle(String pageTitle) {
        if (!DomUtil.isEqual((Object)this.getPageTitle(), (Object)pageTitle)) {
            super.setPageTitle(pageTitle);
            if (this.m_titleBar != null) {
                this.m_titleBar.setPageTitle(pageTitle);
            }
        }
    }

    protected void addPageHeaders() throws Exception {
    }

    protected void addPageTitleBar() {
        this.m_titleBar = DomApplication.get().getDefaultPageTitleBar(this.getPageTitle());
        this.add(this.m_titleBar);
    }

    public void clearGlobalMessages() {
        IErrorFence fence = DomUtil.getMessageFence(this);
        fence.clearGlobalMessages(null);
    }

    public BasePageTitleBar getTitleBar() {
        return this.m_titleBar;
    }

    protected BundleRef getClassBundle(Class<?> c) {
        return MetaManager.findClassMeta(c).getClassBundle();
    }

    protected PropertyMetaModel<?> getPropertyModel(String p) {
        return MetaManager.findPropertyMeta(this.getBaseClass(), p);
    }

    protected BundleRef getBaseClassBundle() {
        return MetaManager.findClassMeta(this.getBaseClass()).getClassBundle();
    }
}

