/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.pages.generic;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.buttons.LinkButton;
import to.etc.domui.component.layout.title.AppPageTitleBar;
import to.etc.domui.component.misc.MsgBox;
import to.etc.domui.component.ntbl.IRowButtonFactory;
import to.etc.domui.component.tbl.DataPager;
import to.etc.domui.component.tbl.DataTable;
import to.etc.domui.component.tbl.RowButtonContainer;
import to.etc.domui.component.tbl.RowRenderer;
import to.etc.domui.component.tbl.SortableListModel;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.UrlPage;
import to.etc.domui.server.ServerClientRegistry;
import to.etc.domui.util.INodeContentRenderer;
import to.etc.util.StringTool;

public class CurrentlyLoggedInUsersPage
extends UrlPage {
    @Override
    public void createContent() throws Exception {
        this.createHeader();
        List<ServerClientRegistry.Client> activeClients = ServerClientRegistry.getInstance().getActiveClients();
        Collections.sort(activeClients, new Comparator<ServerClientRegistry.Client>(){

            @Override
            public int compare(ServerClientRegistry.Client o1, ServerClientRegistry.Client o2) {
                String b;
                String a = o1.getRemoteUser();
                if (a == (b = o2.getRemoteUser())) {
                    return 0;
                }
                if (a == null) {
                    return -1;
                }
                if (b == null) {
                    return 1;
                }
                return a.compareTo(b);
            }
        });
        final long cts = System.currentTimeMillis();
        final SimpleDateFormat df = new SimpleDateFormat("MM/dd HH:mm:ss");
        SortableListModel<ServerClientRegistry.Client> sm = new SortableListModel<ServerClientRegistry.Client>(ServerClientRegistry.Client.class, activeClients);
        RowRenderer<ServerClientRegistry.Client> rr = new RowRenderer<ServerClientRegistry.Client>(ServerClientRegistry.Client.class);
        rr.column("remoteUser").width("10%").label("User ID");
        rr.column().label("IP Address/host").width("1%").renderer(new INodeContentRenderer<ServerClientRegistry.Client>(){

            @Override
            public void renderNodeContent(@Nonnull NodeBase component, @Nonnull NodeContainer node, @Nullable ServerClientRegistry.Client cl, @Nullable Object parameters) throws Exception {
                if (null == cl) {
                    return;
                }
                node.add(cl.getRemoteAddress() + "/" + cl.getRemoteHost());
            }
        });
        rr.column("NRequests").width("1%").label("# requests");
        rr.column(Long.class, "tsSessionStart").width("1%").label("Logged in since").descending().renderer(new INodeContentRenderer<Long>(){

            @Override
            public void renderNodeContent(@Nonnull NodeBase component, @Nonnull NodeContainer node, @Nullable Long cl, @Nullable Object parameters) throws Exception {
                if (null == cl) {
                    return;
                }
                long ts = cl;
                node.add(df.format(new Date(ts)) + " (" + StringTool.strDurationMillis((long)(cts - ts)) + ")");
            }
        });
        rr.column(Long.class, "tsLastRequest").width("1%").label("Last use").sortdefault().descending().renderer(new INodeContentRenderer<Long>(){

            @Override
            public void renderNodeContent(@Nonnull NodeBase component, @Nonnull NodeContainer node, @Nullable Long cl, @Nullable Object parameters) throws Exception {
                if (null == cl) {
                    return;
                }
                long ts = cl;
                node.add(df.format(new Date(ts)) + " (" + StringTool.strDurationMillis((long)(cts - ts)) + ")");
            }
        });
        rr.setRowButtonFactory(new IRowButtonFactory<ServerClientRegistry.Client>(){

            @Override
            public void addButtonsFor(@Nonnull RowButtonContainer c, final @Nonnull ServerClientRegistry.Client data) throws Exception {
                c.addLinkButton("Last used pages", "THEME/btnEdit.png", new IClicked<LinkButton>(){

                    @Override
                    public void clicked(@Nonnull LinkButton clickednode) throws Exception {
                        CurrentlyLoggedInUsersPage.this.showClientData(data);
                    }
                });
            }
        });
        DataTable<ServerClientRegistry.Client> dt = new DataTable<ServerClientRegistry.Client>(sm, rr);
        this.add(dt);
        dt.setPageSize(50);
        this.add(new DataPager(dt));
    }

    protected void showClientData(ServerClientRegistry.Client fcl) {
        Div d = new Div();
        TBody nb = d.addTable("When", "Url");
        nb.getTable().setCssClass("listtbl");
        nb.getTable().setCellPadding("0");
        nb.getTable().setCellSpacing("0");
        long cts = System.currentTimeMillis();
        SimpleDateFormat df = new SimpleDateFormat("MM/dd HH:mm:ss");
        for (ServerClientRegistry.Use u : fcl.getLastUseList()) {
            TD td = nb.addRowAndCell();
            td.setNowrap(true);
            td.setText(df.format(new Date(u.getTimeStamp())) + " (" + StringTool.strDurationMillis((long)(cts - u.getTimeStamp())) + " ago)");
            td = nb.addCell();
            td.setNowrap(true);
            td.setText(u.getUrl());
        }
        MsgBox.info((NodeBase)this, d);
    }

    protected void createHeader() {
        this.add(new AppPageTitleBar("Users currently using this system", true));
    }
}

