/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.parts;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import to.etc.domui.caches.images.FullImage;
import to.etc.domui.caches.images.IImageMemorySource;
import to.etc.domui.caches.images.ImageCache;
import to.etc.domui.caches.images.ImageKey;
import to.etc.domui.server.ApplicationRequestHandler;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.IParameterInfo;
import to.etc.domui.server.IRequestContext;
import to.etc.domui.server.RequestContextImpl;
import to.etc.domui.server.parts.IUnbufferedPartFactory;
import to.etc.domui.state.IPageParameters;
import to.etc.domui.state.PageParameters;
import to.etc.domui.state.UIContext;
import to.etc.domui.trouble.ExpiredDataPage;
import to.etc.domui.trouble.ThingyNotFoundException;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.images.IImageRetriever;
import to.etc.domui.util.images.converters.IImageConversionSpecifier;
import to.etc.domui.util.images.converters.ImageConvert;
import to.etc.domui.util.images.converters.ImagePageSelect;
import to.etc.domui.util.images.converters.ImageResize;
import to.etc.domui.util.images.converters.ImageThumbnail;
import to.etc.util.FileTool;
import to.etc.util.StringTool;
import to.etc.webapp.core.ServerTools;

public class CachedImagePart
implements IUnbufferedPartFactory {
    private static final String IDENTIFICATION_FAILED_FOR_FILE = "Identify failed for file:";
    public static String PARAM_PAGE = "page";
    public static String PARAM_THUMBNAIL = "thumbnail";
    public static String PARAM_FORMAT = "format";
    public static String PARAM_RESIZE = "resize";
    public static String PARAM_FILENAME = "filename";
    public static String PARAM_DISPOSITION = "disposition";

    @Override
    public void generate(@Nonnull DomApplication app, @Nonnull String rurl, @Nonnull RequestContextImpl param) throws Exception {
        String[] ar = rurl.split("/");
        if (ar == null || ar.length != 2) {
            throw new ThingyNotFoundException("Image '" + rurl + "'not found (bad rurl).");
        }
        ImageKey ikey = ImageCache.getInstance().createImageKey(ar[0], ar[1]);
        if (ikey == null) {
            throw new ThingyNotFoundException("The image source '" + ar[0] + "' is not registered/known");
        }
        ArrayList<IImageConversionSpecifier> conversions = new ArrayList<IImageConversionSpecifier>(10);
        this.decodeMutations(param, conversions);
        FullImage fima = null;
        try {
            fima = ImageCache.getInstance().getFullImage(ikey, conversions);
        }
        catch (IllegalStateException se) {
            String exceptionMessage = se.getMessage();
            if (!StringTool.isBlank((String)exceptionMessage) && exceptionMessage.contains(IDENTIFICATION_FAILED_FOR_FILE)) {
                String message = "Helaas is het niet mogelijk dit bestand te verwerken. Controleer het bestand.<br/>Technische details: " + exceptionMessage;
                PageParameters pp = new PageParameters("errorMessage", message);
                ApplicationRequestHandler.generateHttpRedirect(param, DomUtil.createPageURL(ExpiredDataPage.class, (IPageParameters)pp), "missing resource");
                return;
            }
            throw se;
        }
        if (fima == null) {
            throw new ThingyNotFoundException("The image '" + rurl + "' is not known in it's factory");
        }
        this.generateImage(param, fima);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateImage(RequestContextImpl ri, FullImage fima) throws Exception {
        String filename = ri.getParameter(PARAM_FILENAME);
        String dis = ri.getParameter(PARAM_DISPOSITION);
        if (dis != null || filename != null) {
            StringBuilder sb = new StringBuilder();
            if (dis == null) {
                dis = "inline";
            }
            sb.append(dis);
            if (filename != null) {
                sb.append(";");
                sb.append("filename=");
                sb.append(filename);
            }
            ri.getRequestResponse().addHeader("Content-Disposition", sb.toString());
        }
        OutputStream os = ri.getRequestResponse().getOutputStream(fima.getInfo().getMime(), null, fima.getSource().getSize());
        InputStream is = null;
        try {
            if (fima.getSource() instanceof IImageMemorySource) {
                for (byte[] buf : ((IImageMemorySource)fima.getSource()).getImageBuffers()) {
                    os.write(buf);
                }
            } else {
                is = fima.getSource().getImageStream();
                FileTool.copyFile((OutputStream)os, (InputStream)is);
            }
            os.close();
            os = null;
        }
        catch (Throwable throwable) {
            FileTool.closeAll((Object[])new Object[]{is, os});
            throw throwable;
        }
        FileTool.closeAll((Object[])new Object[]{is, os});
    }

    protected void decodeMutations(IParameterInfo pin, List<IImageConversionSpecifier> list) throws Exception {
        this.decodePage(pin, list);
        this.decodeResize(pin, list);
        this.decodeFormat(pin, list);
    }

    protected void decodeResize(IParameterInfo pin, List<IImageConversionSpecifier> ik) throws Exception {
        int p;
        boolean thumb = false;
        String v = pin.getParameter(PARAM_RESIZE);
        if (v == null) {
            v = pin.getParameter(PARAM_THUMBNAIL);
            if (v == null) {
                return;
            }
            thumb = true;
        }
        if ((p = v.indexOf(120)) != -1) {
            String ws = v.substring(0, p).trim();
            String hs = v.substring(p + 1).trim();
            try {
                int w = Integer.parseInt(ws);
                int h = Integer.parseInt(hs);
                ik.add(thumb ? new ImageThumbnail(w, h) : new ImageResize(w, h));
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new IllegalStateException("The value of 'resize' or 'thumbnail' must be a size spec in the format 'wxh', like '300x200', not '" + v + "'");
    }

    protected void decodePage(IParameterInfo pin, List<IImageConversionSpecifier> ik) throws Exception {
        String v = pin.getParameter(PARAM_PAGE);
        if (v == null) {
            return;
        }
        int pnr = Integer.parseInt(v);
        ik.add(new ImagePageSelect(pnr));
    }

    protected void decodeFormat(IParameterInfo pin, List<IImageConversionSpecifier> ik) throws Exception {
        String v = pin.getParameter(PARAM_FORMAT);
        if (v == null) {
            return;
        }
        String mime = v;
        if (mime.indexOf(47) == -1 && (mime = ServerTools.getExtMimeType((String)v.toLowerCase())) == null) {
            throw new IllegalStateException("Cannot find a mime type for format=" + v);
        }
        ik.add(new ImageConvert(mime));
    }

    public static String getURL(String providerkey, String instancekey, String ... convs) {
        StringBuilder sb = new StringBuilder();
        sb.append(CachedImagePart.class.getName());
        sb.append(".part");
        sb.append('/');
        sb.append(providerkey);
        sb.append('/');
        sb.append(instancekey);
        int ix = 0;
        for (String cv : convs) {
            sb.append(ix == 0 ? "?" : "&");
            sb.append(cv);
            ++ix;
        }
        return UIContext.getRequestContext().getRelativePath(sb.toString());
    }

    public static String getRelativeURL(String providerkey, String instancekey, IPageParameters pp) {
        StringBuilder sb = new StringBuilder();
        sb.append(CachedImagePart.class.getName());
        sb.append(".part");
        sb.append('/');
        sb.append(providerkey);
        sb.append('/');
        sb.append(instancekey);
        DomUtil.addUrlParameters(sb, pp, true);
        return DomUtil.getRelativeApplicationResourceURL(sb.toString());
    }

    public static class ImageKeys {
        private DomApplication m_application;
        private IRequestContext m_requestContext;
        private String m_rurl;
        private IImageRetriever m_retriever;
        private Object m_key;
        private List<IImageConversionSpecifier> m_conversions = new ArrayList<IImageConversionSpecifier>(10);

        public ImageKeys(DomApplication application, IRequestContext requestContext, String rurl) {
            this.m_application = application;
            this.m_requestContext = requestContext;
            this.m_rurl = rurl;
        }

        public IImageRetriever getRetriever() {
            return this.m_retriever;
        }

        public void setRetriever(IImageRetriever retriever) {
            this.m_retriever = retriever;
        }

        public Object getKey() {
            return this.m_key;
        }

        public void setKey(Object key) {
            this.m_key = key;
        }

        public List<IImageConversionSpecifier> getConversions() {
            return this.m_conversions;
        }

        public void setConversions(List<IImageConversionSpecifier> conversions) {
            this.m_conversions = conversions;
        }

        public DomApplication getApplication() {
            return this.m_application;
        }

        public IRequestContext getRequestContext() {
            return this.m_requestContext;
        }

        public String getRURL() {
            return this.m_rurl;
        }
    }
}

