/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.parts;

import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.Page;
import to.etc.domui.dom.html.UrlPage;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.IRequestContext;
import to.etc.domui.server.IServerSession;
import to.etc.domui.server.RequestContextImpl;
import to.etc.domui.server.parts.IPartFactory;
import to.etc.domui.state.CidPair;
import to.etc.domui.state.ConversationContext;
import to.etc.domui.state.PageMaker;
import to.etc.domui.state.WindowSession;
import to.etc.domui.trouble.ThingyNotFoundException;

public class ComponentPartRenderer {
    private String[] m_args;
    private Class<? extends UrlPage> m_pageClass;
    private Page m_page;
    private NodeBase m_component;

    public void initialize(DomApplication app, RequestContextImpl param, String rurl) throws Exception {
        int jsid = rurl.toLowerCase().indexOf(";jsessionid=");
        if (jsid != -1) {
            rurl = rurl.substring(0, jsid);
        }
        this.m_args = rurl.split("/");
        if (this.m_args.length < 3) {
            throw new IllegalStateException("Invalid input URL '" + rurl + "': must be in format cid/pageclass/componentID/resourceType.");
        }
        String cids = this.m_args[0];
        String pname = this.m_args[1];
        String wid = this.m_args[2];
        if (pname.length() == 0) {
            throw new IllegalStateException("Missing 'c' parameter (page class name)");
        }
        if (cids.length() == 0) {
            throw new IllegalStateException("Missing 'cid' parameter");
        }
        this.m_pageClass = app.loadPageClass(pname);
        this.m_page = PageMaker.findPageInConversation(param, this.m_pageClass, cids);
        if (this.m_page == null) {
            throw new ThingyNotFoundException("The page " + pname + " cannot be found in conversation " + cids);
        }
        if (wid == null) {
            throw new IllegalStateException("Missing 'id' parameter");
        }
        this.m_component = this.m_page.findNodeByID(wid);
        if (this.m_component == null) {
            throw new ThingyNotFoundException("The component " + wid + " on page " + pname + " cannot be found in conversation " + cids);
        }
        CidPair cida = CidPair.decode(cids);
        WindowSession windowSession = param.getSession().findWindowSession(cida.getWindowId());
        param.internalSetWindowSession(windowSession);
    }

    public String[] getArgs() {
        return this.m_args;
    }

    public Class<? extends UrlPage> getPageClass() {
        return this.m_pageClass;
    }

    public Page getPage() {
        return this.m_page;
    }

    public NodeBase getComponent() {
        return this.m_component;
    }

    public ConversationContext getConversation() {
        return this.m_page.getConversation();
    }

    public static void appendComponentURL(StringBuilder sb, Class<? extends IPartFactory> fclazz, NodeBase b, IRequestContext ctx) {
        sb.append(ctx.getRelativePath(fclazz.getName()));
        sb.append(".part/");
        sb.append(b.getPage().getConversation().getFullId());
        sb.append("/");
        sb.append(b.getPage().getBody().getClass().getName());
        sb.append("/");
        sb.append(b.getActualID());
        if (ctx instanceof RequestContextImpl) {
            IServerSession hs = ctx.getServerSession(true);
            if (null == hs) {
                throw new IllegalStateException("?");
            }
            String sessid = hs.getId();
            sb.append(";jsessionid=").append(sessid);
        }
    }
}

