/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.parts;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.IExtendedParameterInfo;
import to.etc.domui.server.parts.IBufferedPartFactory;
import to.etc.domui.server.parts.PartResponse;
import to.etc.domui.util.resources.IResourceDependencyList;
import to.etc.util.FileTool;

public class FileTypePart
implements IBufferedPartFactory {
    private static final String PREFIX = "$filetype$";

    @Override
    @Nonnull
    public Object decodeKey(@Nonnull String rurl, @Nonnull IExtendedParameterInfo param) throws Exception {
        return PREFIX + rurl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(@Nonnull PartResponse pr, @Nonnull DomApplication da, @Nonnull Object key, @Nonnull IResourceDependencyList rdl) throws Exception {
        String ext = ((String)key).substring(PREFIX.length()).toLowerCase();
        if (ext.length() == 0) {
            ext = "generic";
        }
        InputStream is = null;
        try {
            File src = da.getAppFile("resources/filetypes/" + ext + ".png");
            if (src.exists()) {
                is = new FileInputStream(src);
            } else {
                is = da.getClass().getResourceAsStream("/resources/filetypes/" + ext + ".png");
                if (is == null) {
                    is = da.getClass().getResourceAsStream("/resources/filetypes/generic.png");
                }
            }
            if (is == null) {
                throw new IllegalStateException("File type " + ext + " not found.");
            }
            FileTool.copyFile((OutputStream)pr.getOutputStream(), (InputStream)is);
            pr.setMime("image/png");
            pr.setCacheTime(da.getDefaultExpiryTime());
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static String getURL(String ext) {
        return FileTypePart.class.getName() + ".part/" + ext;
    }
}

