/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.parts;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import to.etc.domui.parts.PartUtil;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.IExtendedParameterInfo;
import to.etc.domui.server.parts.IBufferedPartFactory;
import to.etc.domui.server.parts.PartResponse;
import to.etc.domui.util.resources.IResourceDependencyList;
import to.etc.util.StringTool;

public class GrayscalerPart
implements IBufferedPartFactory {
    @Override
    @Nonnull
    public Object decodeKey(@Nonnull String rurl, @Nonnull IExtendedParameterInfo param) throws Exception {
        String icon = param.getParameter("icon");
        if (null == icon) {
            throw new IllegalStateException("Missing icon parameter");
        }
        boolean isSprite = "true".equalsIgnoreCase(param.getParameter("sprite"));
        return new Key(icon, isSprite);
    }

    @Override
    public void generate(@Nonnull PartResponse pr, @Nonnull DomApplication da, @Nonnull Object key, @Nonnull IResourceDependencyList rdl) throws Exception {
        Key k = (Key)key;
        BufferedImage bi = PartUtil.loadImage(da, k.getIcon(), rdl);
        bi = k.isSprite() ? this.prepareSpriteImage(bi) : this.prepareImage(bi);
        ImageIO.write((RenderedImage)bi, "png", pr.getOutputStream());
        pr.setMime("image/png");
        pr.setCacheTime(da.getDefaultExpiryTime());
    }

    @Nonnull
    private BufferedImage prepareImage(@Nonnull BufferedImage image) {
        this.convertToGrayscale(image);
        return image;
    }

    @Nonnull
    private BufferedImage prepareSpriteImage(BufferedImage image) {
        BufferedImage sprite = new BufferedImage(image.getWidth(), 2 * image.getHeight(), 2);
        Graphics2D g2 = sprite.createGraphics();
        g2.drawImage(image, null, 0, 0);
        this.convertToGrayscale(image);
        g2.drawImage(image, null, 0, image.getHeight());
        g2.dispose();
        return sprite;
    }

    private void convertToGrayscale(BufferedImage image) {
        int y = image.getHeight();
        while (--y >= 0) {
            int x = image.getWidth();
            while (--x >= 0) {
                int argb = image.getRGB(x, y);
                int a = argb & 0xFF000000;
                int r = argb >> 16 & 0xFF;
                int g = argb >> 8 & 0xFF;
                int b = argb & 0xFF;
                int lum = (int)((double)r * 0.299 + (double)g * 0.587 + (double)b * 0.114);
                argb = a + (lum << 16) + (lum << 8) + lum;
                image.setRGB(x, y, argb);
            }
        }
    }

    @Nonnull
    public static String getURL(@Nonnull String icon) {
        StringBuilder sb = new StringBuilder();
        sb.append(GrayscalerPart.class.getName()).append(".part?icon=");
        StringTool.encodeURLEncoded((Appendable)sb, (String)icon);
        return sb.toString();
    }

    @Nonnull
    public static String getSpriteURL(@Nonnull String icon) {
        StringBuilder sb = new StringBuilder();
        sb.append(GrayscalerPart.class.getName()).append(".part?sprite=true&icon=");
        StringTool.encodeURLEncoded((Appendable)sb, (String)icon);
        return sb.toString();
    }

    public static class Key {
        @Nonnull
        private final String m_icon;
        private final boolean m_sprite;

        public Key(@Nonnull String icon, boolean isSprite) {
            this.m_icon = icon;
            this.m_sprite = isSprite;
        }

        @Nonnull
        public String getIcon() {
            return this.m_icon;
        }

        public boolean isSprite() {
            return this.m_sprite;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.m_icon == null ? 0 : this.m_icon.hashCode());
            result = 31 * result + (this.m_sprite ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.m_sprite != other.m_sprite) {
                return false;
            }
            return !(this.m_icon == null ? other.m_icon != null : !this.m_icon.equals(other.m_icon));
        }
    }
}

