/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.parts;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import to.etc.domui.parts.MarkerImagePartKey;
import to.etc.domui.parts.PartUtil;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.IExtendedParameterInfo;
import to.etc.domui.server.parts.IBufferedPartFactory;
import to.etc.domui.server.parts.PartResponse;
import to.etc.domui.state.UIContext;
import to.etc.domui.themes.DefaultThemeVariant;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.resources.IResourceDependencyList;
import to.etc.util.FileTool;

public class MarkerImagePart
implements IBufferedPartFactory {
    private static final String DEFAULT_ICON = "THEME/icon-search.png";
    private static final Color DEFAULT_COLOR = Color.GRAY;

    @Override
    @Nonnull
    public Object decodeKey(@Nonnull String rurl, @Nonnull IExtendedParameterInfo param) throws Exception {
        MarkerImagePartKey key = MarkerImagePartKey.decode(param);
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(@Nonnull PartResponse pr, @Nonnull DomApplication da, @Nonnull Object key, @Nonnull IResourceDependencyList rdl) throws Exception {
        MarkerImagePartKey sipKey = (MarkerImagePartKey)key;
        InputStream is = null;
        try {
            BufferedImage bi = PartUtil.loadImage(da, da.internalGetThemeManager().getThemedResourceRURL(DefaultThemeVariant.INSTANCE, DomUtil.isBlank(sipKey.getIcon()) ? DEFAULT_ICON : sipKey.getIcon().trim()), rdl);
            is = this.getInputStream(this.drawImage(bi, sipKey));
            if (is == null) {
                throw new IllegalStateException("Image is generated incorrectly");
            }
            FileTool.copyFile((OutputStream)pr.getOutputStream(), (InputStream)is);
            pr.setMime("image/png");
            pr.setCacheTime(da.getDefaultExpiryTime());
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private InputStream getInputStream(BufferedImage bi) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bi, "png", os);
        ByteArrayInputStream stream = new ByteArrayInputStream(os.toByteArray());
        return stream;
    }

    private static String getURL(String icon, String caption, String color) {
        if (null != icon && icon.startsWith("THEME/")) {
            System.err.println("BAD ICON SPEC: " + icon);
            throw new IllegalStateException("BAD ICON SPEC: " + icon);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(MarkerImagePart.class.getName()).append(".part");
        boolean paramExists = false;
        paramExists = MarkerImagePartKey.appendParam(sb, paramExists, "icon", icon);
        paramExists = MarkerImagePartKey.appendParam(sb, paramExists, "caption", caption);
        paramExists = MarkerImagePartKey.appendParam(sb, paramExists, "color", color);
        return sb.toString();
    }

    private static String getURL(String icon, String caption, String color, String font, int size, String spec) {
        if (null != icon && icon.startsWith("THEME/")) {
            System.err.println("BAD ICON SPEC: " + icon);
            throw new IllegalStateException("BAD ICON SPEC: " + icon);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(MarkerImagePart.class.getName()).append(".part");
        boolean paramExists = false;
        paramExists = MarkerImagePartKey.appendParam(sb, paramExists, "icon", icon);
        paramExists = MarkerImagePartKey.appendParam(sb, paramExists, "caption", caption);
        paramExists = MarkerImagePartKey.appendParam(sb, paramExists, "color", color);
        paramExists = MarkerImagePartKey.appendParam(sb, paramExists, "font", font);
        paramExists = MarkerImagePartKey.appendParam(sb, paramExists, "fontsize", Integer.toString(size));
        paramExists = MarkerImagePartKey.appendParam(sb, paramExists, "fontspec", spec);
        return sb.toString();
    }

    public static String getBackgroundIconOnly() {
        return MarkerImagePart.getBackgroundImage(null, null, null);
    }

    public static String getBackgroundIconOnly(String icon) {
        return MarkerImagePart.getBackgroundImage(icon, null, null);
    }

    public static String getBackgroundImage(String caption) {
        return MarkerImagePart.getBackgroundImage(null, caption, null);
    }

    public static String getBackgroundImage(String icon, String caption) {
        return MarkerImagePart.getBackgroundImage(icon, caption, null);
    }

    public static String getBackgroundImage(String icon, String caption, String color) {
        String url = UIContext.getRequestContext().getRelativePath(MarkerImagePart.getURL(icon, caption, color));
        return url;
    }

    public static String getBackgroundImage(String icon, String caption, String color, String font, int size, String spec) {
        String url = UIContext.getRequestContext().getRelativePath(MarkerImagePart.getURL(icon, caption, color, font, size, spec));
        return url;
    }

    private BufferedImage drawImage(@Nonnull BufferedImage icon, MarkerImagePartKey key) {
        BufferedImage bufferedImage = new BufferedImage(200, 20, 3);
        Graphics2D g = bufferedImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setComposite(this.makeComposite(0.3f));
        g.drawImage(icon, null, 0, 0);
        if (!DomUtil.isBlank(key.getCaption())) {
            int size;
            String caption = key.getCaption();
            String fontname = key.getFont();
            if (DomUtil.isBlank(fontname)) {
                fontname = "Helvetica";
            }
            if ((size = key.getFontSize()) <= 0) {
                size = 10;
            }
            int style = 0;
            switch (key.getFontSpec()) {
                default: {
                    throw new IllegalStateException((Object)((Object)key.getFontSpec()) + ": unsupported??");
                }
                case BOLD: {
                    style = 1;
                    break;
                }
                case ITALICS: {
                    style = 2;
                    break;
                }
                case BOLD_ITALICS: {
                    style = 3;
                    break;
                }
                case NORM: {
                    style = 0;
                }
            }
            Font font = new Font(fontname, style, size);
            Color capColor = null;
            if (!DomUtil.isBlank(key.getColor())) {
                try {
                    String captionColor = key.getColor();
                    if (captionColor.startsWith("#")) {
                        captionColor = captionColor.substring(1);
                    }
                    capColor = new Color(Integer.parseInt(captionColor, 16));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (capColor == null) {
                capColor = DEFAULT_COLOR;
            }
            this.drawText(g, font, caption, 21, 1, Color.WHITE);
            this.drawText(g, font, caption, 20, 0, capColor);
        }
        return bufferedImage;
    }

    private AlphaComposite makeComposite(float alpha) {
        int type = 3;
        return AlphaComposite.getInstance(type, alpha);
    }

    private void drawText(Graphics2D g, Font font, String textValue, int x, int y, Color stringColor) {
        Font oldFont = g.getFont();
        Color old = g.getColor();
        g.setFont(font);
        g.setColor(stringColor);
        FontMetrics fm = g.getFontMetrics();
        int startX = x;
        int startY = y + fm.getHeight() - 1;
        g.drawString(textValue, startX, startY);
        g.setColor(old);
        g.setFont(oldFont);
    }
}

