/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.parts;

import to.etc.domui.server.IExtendedParameterInfo;
import to.etc.domui.util.DomUtil;
import to.etc.util.StringTool;

public class MarkerImagePartKey {
    static final String PARAM_ICON = "icon";
    static final String PARAM_CAPTION = "caption";
    static final String PARAM_COLOR = "color";
    static final String PARAM_FONT = "font";
    static final String PARAM_FONTSIZE = "fontsize";
    static final String PARAM_SPEC = "fontspec";
    private String m_icon;
    private String m_caption;
    private String m_color;
    private String m_font;
    private int m_fontSize;
    private FontSpec m_fontSpec;

    public static MarkerImagePartKey decode(IExtendedParameterInfo info) {
        FontSpec fs;
        MarkerImagePartKey k = new MarkerImagePartKey();
        k.setCaption(info.getParameter(PARAM_CAPTION));
        k.setIcon(info.getParameter(PARAM_ICON));
        k.setColor(info.getParameter(PARAM_COLOR));
        k.setFont(info.getParameter(PARAM_FONT));
        String s = info.getParameter(PARAM_FONTSIZE);
        if (DomUtil.isBlank(s)) {
            k.setFontSize(0);
        } else {
            k.setFontSize(Integer.parseInt(s));
        }
        s = info.getParameter(PARAM_SPEC);
        if ("b".equalsIgnoreCase(s)) {
            fs = FontSpec.BOLD;
        } else if ("i".equalsIgnoreCase(s)) {
            fs = FontSpec.ITALICS;
        } else if ("bi".equalsIgnoreCase(s) || "ib".equalsIgnoreCase(s)) {
            fs = FontSpec.BOLD_ITALICS;
        } else if (DomUtil.isBlank(s)) {
            fs = FontSpec.NORM;
        } else {
            throw new IllegalArgumentException(s + ": font spec must be empty, i, b or ib");
        }
        k.setFontSpec(fs);
        return k;
    }

    static boolean appendParam(StringBuilder sb, boolean paramExists, String paramName, String value) {
        if (value != null) {
            sb.append(paramExists ? "&" : "?");
            sb.append(paramName + "=");
            StringTool.encodeURLEncoded((Appendable)sb, (String)value);
            return true;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_caption == null ? 0 : this.m_caption.hashCode());
        result = 31 * result + (this.m_color == null ? 0 : this.m_color.hashCode());
        result = 31 * result + (this.m_font == null ? 0 : this.m_font.hashCode());
        result = 31 * result + this.m_fontSize;
        result = 31 * result + (this.m_fontSpec == null ? 0 : this.m_fontSpec.hashCode());
        result = 31 * result + (this.m_icon == null ? 0 : this.m_icon.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MarkerImagePartKey other = (MarkerImagePartKey)obj;
        if (this.m_caption == null ? other.m_caption != null : !this.m_caption.equals(other.m_caption)) {
            return false;
        }
        if (this.m_color == null ? other.m_color != null : !this.m_color.equals(other.m_color)) {
            return false;
        }
        if (this.m_font == null ? other.m_font != null : !this.m_font.equals(other.m_font)) {
            return false;
        }
        if (this.m_fontSize != other.m_fontSize) {
            return false;
        }
        if (this.m_fontSpec != other.m_fontSpec) {
            return false;
        }
        return !(this.m_icon == null ? other.m_icon != null : !this.m_icon.equals(other.m_icon));
    }

    public void setIcon(String icon) {
        this.m_icon = icon;
    }

    public String getIcon() {
        return this.m_icon;
    }

    public void setCaption(String text) {
        this.m_caption = text;
    }

    public String getCaption() {
        return this.m_caption;
    }

    void setColor(String color) {
        this.m_color = color;
    }

    String getColor() {
        return this.m_color;
    }

    public String getFont() {
        return this.m_font;
    }

    public void setFont(String font) {
        this.m_font = font;
    }

    public int getFontSize() {
        return this.m_fontSize;
    }

    public void setFontSize(int fontSize) {
        this.m_fontSize = fontSize;
    }

    public FontSpec getFontSpec() {
        return this.m_fontSpec;
    }

    public void setFontSpec(FontSpec fontSpec) {
        this.m_fontSpec = fontSpec;
    }

    public static enum FontSpec {
        NORM,
        BOLD,
        ITALICS,
        BOLD_ITALICS;

    }
}

