/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.parts;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import to.etc.domui.server.IParameterInfo;
import to.etc.util.StringTool;

public class ParameterInfoImpl
implements IParameterInfo {
    private Map<String, String[]> m_parameterMap = new HashMap<String, String[]>();

    public ParameterInfoImpl(String in) {
        String[] arg = in.split("&");
        if (arg == null || arg.length == 0) {
            arg = new String[]{in};
        }
        for (String s : arg) {
            int pos = s.indexOf(61);
            if (pos == -1) continue;
            String name = s.substring(0, pos);
            String value = s.substring(pos + 1);
            name = StringTool.decodeURLEncoded((String)name);
            value = StringTool.decodeURLEncoded((String)value);
            this.add(name, value);
        }
    }

    private void add(String name, String value) {
        String[] v = this.m_parameterMap.get(name);
        if (v == null) {
            v = new String[]{value};
        } else {
            String[] nw = new String[v.length + 1];
            System.arraycopy(v, 0, nw, 0, v.length);
            nw[v.length] = value;
            v = nw;
        }
        this.m_parameterMap.put(name, v);
    }

    @Override
    public String getParameter(@Nonnull String name) {
        String[] v = this.m_parameterMap.get(name);
        if (v == null || v.length != 1) {
            return null;
        }
        return v[0];
    }

    @Override
    @Nonnull
    public String[] getParameterNames() {
        return this.m_parameterMap.keySet().toArray(new String[this.m_parameterMap.size()]);
    }

    @Override
    @Nonnull
    public String[] getParameters(@Nonnull String name) {
        String[] res = this.m_parameterMap.get(name);
        return res == null ? new String[]{} : res;
    }
}

