/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.parts;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import to.etc.domui.parts.ParameterInfoImpl;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.IParameterInfo;
import to.etc.domui.trouble.ThingyNotFoundException;
import to.etc.domui.util.resources.IResourceDependencyList;
import to.etc.domui.util.resources.IResourceRef;
import to.etc.sjit.ImaTool;
import to.etc.util.StringInputStream;

public class PartUtil {
    private static final Map<String, Color> m_colors = new HashMap<String, Color>();

    private PartUtil() {
    }

    public static int getInt(IParameterInfo param, String name, int def) {
        String v = param.getParameter(name);
        if (v == null) {
            return def;
        }
        if ((v = v.trim()).length() == 0) {
            return def;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (Exception x) {
            return def;
        }
    }

    private static boolean isa(String name, String ext) {
        int pos = name.lastIndexOf(46);
        if (pos == -1) {
            return false;
        }
        return name.substring(pos + 1).equalsIgnoreCase(ext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static Properties loadProperties(DomApplication da, String src, IResourceDependencyList rdl) throws Exception {
        String svg = da.getThemeReplacedString(rdl, src);
        StringInputStream is = new StringInputStream(svg, "utf-8");
        try {
            Properties p = new Properties();
            p.load((InputStream)is);
            Properties properties = p;
            return properties;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    public static String getURI(String in) {
        if (in == null) {
            return null;
        }
        int pos = in.indexOf(63);
        if (pos == -1) {
            return in;
        }
        return in.substring(0, pos);
    }

    public static IParameterInfo getParameters(String in) {
        if (in == null) {
            return null;
        }
        int pos = in.indexOf(63);
        if (pos == -1) {
            return null;
        }
        return new ParameterInfoImpl(in.substring(pos + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage loadImage(DomApplication da, String in, @Nonnull IResourceDependencyList rdl) throws Exception {
        String image = PartUtil.getURI(in);
        IParameterInfo param = PartUtil.getParameters(in);
        IResourceRef ref = da.getResource(image, rdl);
        InputStream is = ref.getInputStream();
        if (is == null) {
            throw new ThingyNotFoundException("The image '" + image + "' was not found.");
        }
        BufferedImage bi = null;
        if (PartUtil.isa(image, "gif")) {
            bi = ImaTool.loadGIF((InputStream)is);
        } else if (PartUtil.isa(image, "jpg") || PartUtil.isa(image, "jpeg")) {
            bi = ImaTool.loadJPEG((InputStream)is);
        } else if (PartUtil.isa(image, "png")) {
            bi = ImaTool.loadPNG((InputStream)is);
        } else if (image.endsWith("svg")) {
            bi = PartUtil.loadSvg(da, rdl, image, param);
        } else {
            throw new IllegalArgumentException("The image '" + image + "' must be .gif, .jpg or .jpeg");
        }
        if (bi.getType() == 2) {
            BufferedImage bufferedImage = bi;
            return bufferedImage;
        }
        BufferedImage newbi = new BufferedImage(bi.getWidth(), bi.getHeight(), 2);
        Graphics2D g2d = (Graphics2D)newbi.getGraphics();
        g2d.drawImage((Image)bi, 0, 0, null);
        BufferedImage bufferedImage = newbi;
        return bufferedImage;
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    private static BufferedImage loadSvg(DomApplication da, IResourceDependencyList rdl, String image, IParameterInfo param) throws Exception {
        String svg = da.getThemeReplacedString(rdl, image);
        BufferedImageTranscoder bit = new BufferedImageTranscoder();
        TranscoderInput in = new TranscoderInput((Reader)new StringReader(svg));
        int w = PartUtil.getInt(param, "w", -1);
        int h = PartUtil.getInt(param, "h", -1);
        if (w != -1 && h != -1) {
            bit.addTranscodingHint(SVGAbstractTranscoder.KEY_WIDTH, Float.valueOf(w));
            bit.addTranscodingHint(SVGAbstractTranscoder.KEY_HEIGHT, Float.valueOf(h));
        }
        bit.transcode(in, new TranscoderOutput());
        return bit.getRendered();
    }

    public static Color makeColor(String col) {
        Color c;
        if (col == null) {
            return Color.WHITE;
        }
        if (col.startsWith("#")) {
            col = col.substring(1);
        }
        if ((c = m_colors.get(col.toLowerCase())) != null) {
            return c;
        }
        try {
            int v = Integer.parseInt(col, 16);
            return new Color(v);
        }
        catch (Exception x) {
            return Color.WHITE;
        }
    }

    public static Font getFont(String family, String styles, int size) {
        String txt;
        int style = 0;
        if (styles != null) {
            if ((styles = styles.toLowerCase()).indexOf("i") != -1) {
                style |= 2;
            }
            if (styles.indexOf("b") != -1) {
                style |= 1;
            }
        }
        StringTokenizer st = new StringTokenizer(family, ";");
        Font f = null;
        while (st.hasMoreTokens() && (f = Font.decode(txt = st.nextToken().trim())).getFamily().equals("Dialog")) {
        }
        if (f == null) {
            return new Font("Dialog", style, size);
        }
        return f.deriveFont(style, size);
    }

    static {
        m_colors.put("white", Color.WHITE);
        m_colors.put("black", Color.BLACK);
        m_colors.put("blue", Color.BLUE);
        m_colors.put("cyan", Color.CYAN);
        m_colors.put("darkgray", Color.DARK_GRAY);
        m_colors.put("gray", Color.GRAY);
        m_colors.put("green", Color.GREEN);
        m_colors.put("lightgray", Color.LIGHT_GRAY);
        m_colors.put("magenta", Color.MAGENTA);
        m_colors.put("orange", Color.ORANGE);
        m_colors.put("pink", Color.PINK);
        m_colors.put("red", Color.RED);
        m_colors.put("yellow", Color.YELLOW);
    }

    private static class BufferedImageTranscoder
    extends ImageTranscoder {
        private BufferedImage m_bi;

        public BufferedImage createImage(int w, int h) {
            return new BufferedImage(w, h, 2);
        }

        public void writeImage(BufferedImage img, TranscoderOutput output) throws TranscoderException {
            this.m_bi = img;
        }

        public BufferedImage getRendered() {
            return this.m_bi;
        }
    }
}

