/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.parts;

import java.util.Properties;
import javax.annotation.Nonnull;
import to.etc.domui.parts.ButtonPartKey;
import to.etc.domui.parts.PartUtil;
import to.etc.domui.parts.PropButtonRenderer;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.IExtendedParameterInfo;
import to.etc.domui.server.parts.IBufferedPartFactory;
import to.etc.domui.server.parts.PartResponse;
import to.etc.domui.trouble.ThingyNotFoundException;
import to.etc.domui.util.resources.IResourceDependencyList;

public class PropBtnPart
implements IBufferedPartFactory {
    public static final PropBtnPart INSTANCE = new PropBtnPart();

    @Override
    @Nonnull
    public Object decodeKey(@Nonnull String rurl, @Nonnull IExtendedParameterInfo info) throws Exception {
        return ButtonPartKey.decode(info);
    }

    @Override
    public void generate(@Nonnull PartResponse pr, @Nonnull DomApplication da, @Nonnull Object key, @Nonnull IResourceDependencyList rdl) throws Exception {
        ButtonPartKey k = (ButtonPartKey)key;
        Properties p = PartUtil.loadProperties(da, k.getPropFile(), rdl);
        String rc = p.getProperty("renderer");
        PropButtonRenderer r = null;
        if (rc == null) {
            r = new PropButtonRenderer();
        } else {
            try {
                Class<?> cl = this.getClass().getClassLoader().loadClass(rc);
                if (!PropButtonRenderer.class.isAssignableFrom(cl)) {
                    throw new IllegalStateException("The class does not extend PropButtonRenderer");
                }
                r = (PropButtonRenderer)cl.newInstance();
            }
            catch (Exception x) {
                throw new ThingyNotFoundException("Cannot locate/instantiate the button renderer class '" + rc + "' (specified in " + k.getPropFile() + ")");
            }
        }
        if (p.getProperty("webui.webapp") == null || !da.inDevelopmentMode()) {
            pr.setCacheTime(da.getDefaultExpiryTime());
        }
        r.generate(pr, da, k, p, rdl);
    }
}

