/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.parts;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import to.etc.domui.parts.ButtonPartKey;
import to.etc.domui.parts.PartUtil;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.parts.PartResponse;
import to.etc.domui.util.resources.IResourceDependencyList;

public class PropButtonRenderer {
    private DomApplication m_application;
    private Properties m_properties;
    private ButtonPartKey m_key;
    private IResourceDependencyList m_dependencies;
    private int m_width;
    private int m_height;
    protected BufferedImage m_rootImage;
    private List<BufferedImage> m_images = new ArrayList<BufferedImage>(10);
    private Graphics2D m_targetGraphics;
    protected BufferedImage m_iconImage;
    private String m_actualText;
    private int m_acceleratorIndex = -1;
    private Font m_textFont;
    private AttributedString m_attributedString;
    private Color m_textColor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(PartResponse pr, DomApplication da, ButtonPartKey key, Properties p, @Nonnull IResourceDependencyList rdl) throws Exception {
        this.m_application = da;
        this.m_properties = p;
        this.m_key = key;
        this.m_dependencies = rdl;
        try {
            this.initBackground();
            this.renderBackground();
            this.initIcon();
            this.initTextFont();
            this.initTextColor();
            this.decodeAccelerator();
            this.initAttributedText();
            int totalwidth = 0;
            if (this.m_attributedString != null) {
                FontRenderContext frc = this.getGraphics().getFontRenderContext();
                TextLayout layout = new TextLayout(this.m_attributedString.getIterator(), frc);
                Rectangle2D r = layout.getBounds();
                totalwidth = (int)r.getWidth();
            }
            if (this.m_iconImage != null) {
                totalwidth += this.m_iconImage.getWidth();
                int t = this.getInt("text.icon.xoffset", -999);
                if (t != -999) {
                    totalwidth += t;
                }
                t = this.m_iconImage.getWidth() + this.getInt("icon.xoffset", 10);
                totalwidth += t;
                t = this.getInt("text.iconoffset", 2);
                totalwidth += t;
            } else {
                totalwidth += 20;
            }
            if (totalwidth > this.m_width) {
                this.growRootWider(totalwidth);
            }
            if (this.m_iconImage != null) {
                this.renderIcon();
            }
            if (this.getKey().getText() != null) {
                this.renderAttributedText();
            }
            this.compress(pr);
            Dimension dim = new Dimension(this.m_width, this.m_height);
            pr.setExtra(dim);
        }
        finally {
            try {
                if (null != this.m_targetGraphics) {
                    this.m_targetGraphics.dispose();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void growRootWider(int totalwidth) {
        BufferedImage newbi = new BufferedImage(totalwidth, this.m_rootImage.getHeight(), this.m_rootImage.getType());
        int split = this.getInt("split", this.m_rootImage.getWidth() / 2);
        BufferedImage leftbi = this.m_rootImage.getSubimage(0, 0, split, this.m_rootImage.getHeight());
        Graphics2D g2d = (Graphics2D)newbi.getGraphics();
        try {
            g2d.drawImage((Image)leftbi, 0, 0, null);
            BufferedImage splice = this.m_rootImage.getSubimage(split, 0, 1, this.m_rootImage.getHeight());
            int gapwidth = totalwidth - this.m_rootImage.getWidth();
            int x = split;
            int i = gapwidth;
            while (--i >= 0) {
                g2d.drawImage((Image)splice, x, 0, null);
                ++x;
            }
            BufferedImage rightbi = this.m_rootImage.getSubimage(split, 0, this.m_rootImage.getWidth() - split, this.m_rootImage.getHeight());
            g2d.drawImage((Image)rightbi, split + gapwidth, 0, null);
            this.m_rootImage = newbi;
            this.m_width = totalwidth;
            if (null != this.m_targetGraphics) {
                this.m_targetGraphics.dispose();
            }
            this.m_targetGraphics = null;
        }
        finally {
            try {
                g2d.dispose();
            }
            catch (Exception exception) {}
        }
    }

    protected void compress(PartResponse pr) throws Exception {
        ImageIO.write((RenderedImage)this.m_rootImage, "PNG", pr.getOutputStream());
        pr.setMime("image/png");
    }

    protected void initIcon() throws Exception {
        if (this.getKey().getIcon() == null || this.getKey().getIcon().trim().length() == 0) {
            return;
        }
        this.m_iconImage = this.loadImage("/" + this.getKey().getIcon());
    }

    public Graphics2D getGraphics() {
        if (this.m_targetGraphics == null) {
            this.m_targetGraphics = (Graphics2D)this.m_rootImage.getGraphics();
            this.initAntiAliasing();
        }
        return this.m_targetGraphics;
    }

    protected void initAntiAliasing() {
        String s = this.getProperty("text.antialias");
        if (s == null || !s.toLowerCase().startsWith("f")) {
            this.getGraphics().setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.getGraphics().setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
    }

    protected void initBackground() throws Exception {
        if (this.getKey().getImg() != null) {
            BufferedImage bi = this.loadImage("/" + this.getKey().getImg());
            this.m_images.add(bi);
            this.m_width = bi.getWidth();
            this.m_height = bi.getHeight();
            return;
        }
        String rurl = this.getProperty("bg.image");
        if (null == rurl) {
            throw new IllegalStateException("Missing 'bg.image' key in button properties file");
        }
        BufferedImage bi = this.loadImage(rurl);
        this.m_images.add(bi);
        this.m_width = bi.getWidth();
        this.m_height = bi.getHeight();
        for (int inr = 2; inr < 8; ++inr) {
            rurl = this.getProperty("bg" + inr + ".image");
            if (null == rurl) {
                return;
            }
            bi = this.loadImage(rurl);
            if (this.m_width != bi.getWidth() || this.m_height != bi.getHeight()) {
                throw new IllegalStateException("Size difference between bg and bg" + inr + ": they must have the exact same size");
            }
            this.m_images.add(bi);
        }
    }

    private void renderBackground() throws Exception {
        if (this.m_height == 0 || this.m_images.size() == 0) {
            throw new IllegalStateException();
        }
        int height = this.m_height * this.m_images.size();
        this.m_rootImage = new BufferedImage(this.m_width, height, 2);
        Graphics2D g = this.getGraphics();
        int y = 0;
        for (BufferedImage sbi : this.m_images) {
            g.drawImage((Image)sbi, 0, y, null);
            y += this.m_height;
        }
    }

    protected void renderIcon() throws Exception {
        int xoffset = this.getInt("icon.xoffset", 10);
        int yoffset = this.getInt("icon.yoffset", 0);
        int x = xoffset;
        int y = 0;
        String yalign = this.getProperty("icon.yalign", "center");
        if ("center".equalsIgnoreCase(yalign)) {
            if (this.m_iconImage.getHeight() < this.m_height) {
                y = (this.m_height - this.m_iconImage.getHeight()) / 2 + yoffset;
            }
        } else if ("top".equalsIgnoreCase(yalign)) {
            y = this.m_height - yoffset;
        } else if ("bottom".equalsIgnoreCase(yalign)) {
            y = yoffset;
        } else {
            throw new IllegalStateException("icon.yalign must be 'top', 'bottom', 'center'");
        }
        for (int i = 0; i < this.m_images.size(); ++i) {
            this.getGraphics().drawImage((Image)this.m_iconImage, x, y, null);
            y += this.m_height;
        }
    }

    protected void initTextColor() {
        String col = this.getProperty("text.color", "000000");
        this.m_textColor = PartUtil.makeColor(col);
    }

    protected Color getColor(String key, Color c) {
        String col = this.getProperty(key, null);
        if (col == null) {
            return c;
        }
        return PartUtil.makeColor(col);
    }

    protected void initTextFont() {
        String family = this.getProperty("text.font", "sans");
        String style = this.getProperty("text.style");
        int size = this.getInt("text.size", 12);
        this.m_textFont = PartUtil.getFont(family, style, size);
    }

    protected void decodeAccelerator() {
        String txt = this.getKey().getText();
        if (txt == null) {
            this.m_actualText = "";
            this.m_acceleratorIndex = -1;
            return;
        }
        StringBuilder sb = new StringBuilder(txt.length());
        int accpos = -1;
        int ix = 0;
        int len = txt.length();
        while (ix < len) {
            int pos = txt.indexOf(33, ix);
            if (pos == -1) {
                sb.append(txt, ix, len);
                break;
            }
            if (pos > 0 && txt.charAt(pos - 1) == '\\') {
                sb.append(txt, ix, pos - 1);
                sb.append('!');
                ix = pos + 1;
                continue;
            }
            if (pos + 1 < len && accpos == -1) {
                sb.append(txt, ix, pos);
                accpos = sb.length();
                ix = pos + 1;
                continue;
            }
            sb.append(txt, ix, pos + 1);
            ix = pos + 1;
        }
        this.m_actualText = sb.toString();
        this.m_acceleratorIndex = accpos;
    }

    protected void initAttributedText() {
        if (this.m_actualText == null || this.m_actualText.length() == 0) {
            return;
        }
        this.m_attributedString = new AttributedString(this.m_actualText);
        this.m_attributedString.addAttribute(TextAttribute.FONT, this.m_textFont);
        this.m_attributedString.addAttribute(TextAttribute.FOREGROUND, this.m_textColor);
        this.m_attributedString.addAttribute(TextAttribute.SIZE, Float.valueOf(this.getInt("text.size", 12)));
        if (this.m_acceleratorIndex != -1) {
            this.m_attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL, this.m_acceleratorIndex, this.m_acceleratorIndex + 1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void renderAttributedText() throws Exception {
        FontRenderContext frc = this.getGraphics().getFontRenderContext();
        TextLayout layout = new TextLayout(this.m_attributedString.getIterator(), frc);
        Rectangle2D r = layout.getBounds();
        String xalign = this.getProperty("text.xalign", "center");
        String yalign = this.getProperty("text.yalign", "center");
        int xoffset = this.getInt("text.xoffset", 0);
        int yoffset = this.getInt("text.yoffset", 0);
        int y = 0;
        if ("center".equals(yalign)) {
            int cy = (this.m_height - (int)r.getHeight()) / 2;
            y += cy - (int)r.getY() + yoffset;
        } else if ("top".equals(yalign)) {
            y = this.m_height - (int)r.getHeight() + yoffset;
        } else {
            if (!"bottom".equals(yalign)) throw new IllegalStateException("text.yalign must be top, bottom or center");
            y = yoffset;
        }
        int x = 0;
        if (this.m_iconImage != null) {
            int t;
            String s = this.getProperty("text.icon.xalign");
            if (s != null) {
                xalign = s;
            }
            if ((t = this.getInt("text.icon.xoffset", -999)) != -999) {
                xoffset = t;
            }
            int xfence = this.m_iconImage.getWidth() + this.getInt("icon.xoffset", 10);
            int xiconoff = this.getInt("text.iconoffset", 2);
            xfence += xiconoff;
            if ("center".equals(xalign)) {
                int cx = (this.m_rootImage.getWidth() - (int)r.getWidth() - xfence) / 2;
                if (cx < 0) {
                    cx = 0;
                }
                x = xfence + cx + xoffset;
            } else if ("left".equals(xalign)) {
                x = xfence + xoffset;
            } else {
                if (!"right".equals(xalign)) throw new IllegalStateException("text.xalign must be center,left,right");
                x = this.m_rootImage.getWidth() - (int)r.getWidth() - xoffset;
            }
        } else if ("center".equals(xalign)) {
            int cx = (this.m_rootImage.getWidth() - (int)r.getWidth()) / 2;
            if (cx < 0) {
                cx = 0;
            }
            x = xoffset + cx;
        } else if ("left".equals(xalign)) {
            x = xoffset;
        } else {
            if (!"right".equals(xalign)) throw new IllegalStateException("text.xalign must be center,left,right");
            x = this.m_rootImage.getWidth() - (int)r.getWidth() - xoffset;
        }
        for (int i = 0; i < this.m_images.size(); ++i) {
            layout.draw(this.getGraphics(), x, y);
            y += this.m_height;
        }
    }

    protected BufferedImage loadImage(String rurl) throws Exception {
        int pos;
        String name = (rurl = rurl.trim()).startsWith("/") ? rurl.substring(1) : ((pos = this.getKey().getPropFile().lastIndexOf(47)) == -1 ? rurl : this.getKey().getPropFile().substring(0, pos + 1) + rurl);
        return PartUtil.loadImage(this.getApplication(), name, this.getDependencies());
    }

    public DomApplication getApplication() {
        return this.m_application;
    }

    public IResourceDependencyList getDependencies() {
        return this.m_dependencies;
    }

    public ButtonPartKey getKey() {
        return this.m_key;
    }

    public Properties getProperties() {
        return this.m_properties;
    }

    public String getProperty(String key) {
        return this.getProperties().getProperty(key);
    }

    public String getProperty(String key, String dflt) {
        String s = this.getProperty(key);
        if (s == null || s.trim().length() == 0) {
            return dflt;
        }
        return s;
    }

    public int getInt(String key, int dflt) {
        String s = this.getProperty(key);
        if (s != null) {
            try {
                return Integer.parseInt(s.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dflt;
    }
}

