/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.parts;

import java.io.Reader;
import java.io.StringReader;
import javax.annotation.Nonnull;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import to.etc.domui.parts.PartUtil;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.IExtendedParameterInfo;
import to.etc.domui.server.parts.IBufferedPartFactory;
import to.etc.domui.server.parts.IUrlPart;
import to.etc.domui.server.parts.PartResponse;
import to.etc.domui.util.resources.IResourceDependencyList;

public class SvgPartFactory
implements IBufferedPartFactory,
IUrlPart {
    @Override
    public boolean accepts(@Nonnull String rurl) {
        return rurl.endsWith(".png.svg");
    }

    @Override
    @Nonnull
    public Object decodeKey(@Nonnull String rurl, @Nonnull IExtendedParameterInfo param) throws Exception {
        int width = PartUtil.getInt(param, "w", -1);
        int height = PartUtil.getInt(param, "h", -1);
        return new SvgKey(rurl, width, height);
    }

    @Override
    public void generate(@Nonnull PartResponse pr, @Nonnull DomApplication da, @Nonnull Object key, @Nonnull IResourceDependencyList rdl) throws Exception {
        SvgKey k = (SvgKey)key;
        String svg = da.getThemeReplacedString(rdl, k.getRurl());
        PNGTranscoder coder = new PNGTranscoder();
        TranscoderInput in = new TranscoderInput((Reader)new StringReader(svg));
        TranscoderOutput out = new TranscoderOutput(pr.getOutputStream());
        if (k.getWidth() != -1 && k.getHeight() != -1) {
            coder.addTranscodingHint(SVGAbstractTranscoder.KEY_WIDTH, (Object)Float.valueOf(k.getWidth()));
            coder.addTranscodingHint(SVGAbstractTranscoder.KEY_HEIGHT, (Object)Float.valueOf(k.getHeight()));
        }
        coder.transcode(in, out);
        if (!da.inDevelopmentMode()) {
            pr.setCacheTime(da.getDefaultExpiryTime());
        }
        pr.setMime("image/png");
    }

    private static class SvgKey {
        private String m_rurl;
        private int m_width;
        private int m_height;

        public SvgKey(String rurl, int width, int height) {
            this.m_rurl = rurl;
            this.m_width = width;
            this.m_height = height;
        }

        public String getRurl() {
            return this.m_rurl;
        }

        public int getWidth() {
            return this.m_width;
        }

        public int getHeight() {
            return this.m_height;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.m_height;
            result = 31 * result + (this.m_rurl == null ? 0 : this.m_rurl.hashCode());
            result = 31 * result + this.m_width;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SvgKey other = (SvgKey)obj;
            if (this.m_height != other.m_height) {
                return false;
            }
            if (this.m_rurl == null ? other.m_rurl != null : !this.m_rurl.equals(other.m_rurl)) {
                return false;
            }
            return this.m_width == other.m_width;
        }
    }
}

