/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.parts;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.IRequestContext;
import to.etc.domui.server.RequestContextImpl;
import to.etc.domui.server.parts.IUnbufferedPartFactory;
import to.etc.domui.trouble.ThingyNotFoundException;
import to.etc.util.FileTool;
import to.etc.util.StringTool;
import to.etc.webapp.core.ServerTools;

public class TempDirPart
implements IUnbufferedPartFactory {
    public static String registerTempDir(@Nonnull IRequestContext ctx, @Nonnull File target) {
        String key = StringTool.generateGUID();
        ctx.getSession().setAttribute("tmpdir-" + key, new TmpDir(target));
        StringBuilder sb = new StringBuilder();
        sb.append(TempDirPart.class.getName());
        sb.append(".part/").append(key).append("/");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(@Nonnull DomApplication app, @Nonnull String rurl, @Nonnull RequestContextImpl param) throws Exception {
        int pos = rurl.indexOf(47);
        if (pos == -1) {
            throw new ThingyNotFoundException("No / in path " + rurl);
        }
        String key = rurl.substring(0, pos);
        TmpDir dir = (TmpDir)param.getSession().getAttribute("tmpdir-" + key);
        if (null == dir) {
            throw new ThingyNotFoundException("Tempdir " + key + " not found in session");
        }
        File inside = new File(dir.getDir(), rurl.substring(pos + 1));
        if (!inside.exists() || !inside.isFile()) {
            throw new ThingyNotFoundException(rurl + ": no such temp resource");
        }
        String mime = ServerTools.getMimeType((String)inside.getName());
        if (null == mime) {
            mime = "application/octet-stream";
        }
        OutputStream os = param.getRequestResponse().getOutputStream(mime, null, (int)inside.length());
        FileInputStream is = new FileInputStream(inside);
        try {
            FileTool.copyFile((OutputStream)os, (InputStream)is);
        }
        catch (Throwable throwable) {
            FileTool.closeAll((Object[])new Object[]{is});
            throw throwable;
        }
        FileTool.closeAll((Object[])new Object[]{is});
    }

    private static class TmpDir
    implements HttpSessionBindingListener {
        @Nonnull
        private final File m_dir;

        public TmpDir(@Nonnull File dir) {
            this.m_dir = dir;
        }

        @Nonnull
        public File getDir() {
            return this.m_dir;
        }

        public void valueBound(HttpSessionBindingEvent arg0) {
        }

        public void valueUnbound(HttpSessionBindingEvent arg0) {
            try {
                FileTool.deleteDir((File)this.m_dir);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

