/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.parts;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.IRequestContext;
import to.etc.domui.server.RequestContextImpl;
import to.etc.domui.server.parts.IUnbufferedPartFactory;
import to.etc.domui.state.UIContext;
import to.etc.domui.trouble.ThingyNotFoundException;
import to.etc.util.FileTool;
import to.etc.util.StringTool;

public class TempFilePart
implements IUnbufferedPartFactory {
    @Deprecated
    public static String registerTempFile(@Nonnull IRequestContext ctx, @Nonnull File target, @Nonnull String mime, @Nullable String type, @Nullable String name) {
        String key = StringTool.generateGUID();
        String pw = StringTool.generateGUID();
        String disp = null;
        if (type != null) {
            disp = type + "; filename=" + name;
        }
        FileInfo fi = new FileInfo(pw, target, mime, disp);
        ctx.getSession().setAttribute("tempf-" + key, fi);
        StringBuilder sb = new StringBuilder();
        sb.append(TempFilePart.class.getName());
        sb.append(".part?key=").append(key).append("&passkey=").append(pw);
        return sb.toString();
    }

    public static String registerTempFile(@Nonnull File target, @Nonnull String mime, @Nonnull Disposition disp, @Nullable String name) {
        String key = StringTool.generateGUID();
        String pw = StringTool.generateGUID();
        String s = null;
        switch (disp) {
            default: {
                break;
            }
            case Attachment: {
                s = "attachment";
                break;
            }
            case Inline: {
                s = "inline";
            }
        }
        if (s != null && name != null) {
            name = name.replace(" ", "_");
            s = s + "; filename=" + name;
        }
        FileInfo fi = new FileInfo(pw, target, mime, s);
        IRequestContext rc = UIContext.getRequestContext();
        rc.getSession().setAttribute("tempf-" + key, fi);
        StringBuilder sb = new StringBuilder();
        sb.append(TempFilePart.class.getName());
        sb.append(".part?key=").append(key).append("&passkey=").append(pw);
        return rc.getRelativePath(sb.toString());
    }

    public static String getDownloadLink(@Nonnull IRequestContext ctx, @Nonnull Blob blob, String mime, String type, String filename) throws Exception {
        File temp = File.createTempFile("tmp", ".tmp");
        FileTool.saveBlob((File)temp, (Blob)blob);
        return TempFilePart.registerTempFile(ctx, temp, mime, type, filename);
    }

    public static void createDownloadAction(@Nonnull NodeBase sourcePage, @Nonnull File target, @Nonnull String mime, @Nonnull Disposition disposition, @Nullable String name) {
        String url = TempFilePart.registerTempFile(target, mime, disposition, name);
        sourcePage.appendJavascript("location.href=" + StringTool.strToJavascriptString((String)url, (boolean)true) + ";");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(@Nonnull DomApplication app, @Nonnull String rurl, @Nonnull RequestContextImpl param) throws Exception {
        String fkey = param.getParameter("key");
        String fpw = param.getParameter("passkey");
        if (fkey == null || fpw == null) {
            throw new ThingyNotFoundException("Invalid arguments.");
        }
        FileInfo fi = (FileInfo)param.getSession().getAttribute("tempf-" + fkey);
        if (fi == null || !fi.getPw().equals(fpw) || fi.getSource() == null || !fi.getSource().exists()) {
            throw new ThingyNotFoundException("The content with content-id " + fkey + "/" + fpw + " cannot be found");
        }
        if (fi.getDisposition() != null) {
            param.getRequestResponse().addHeader("Content-Disposition", fi.getDisposition());
        }
        OutputStream os = param.getRequestResponse().getOutputStream(fi.getMime(), null, (int)fi.getSource().length());
        FileInputStream is = new FileInputStream(fi.getSource());
        try {
            FileTool.copyFile((OutputStream)os, (InputStream)is);
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (Exception exception) {}
        }
    }

    public static enum Disposition {
        Attachment,
        Inline,
        None;

    }

    private static class FileInfo {
        private String m_pw;
        private File m_source;
        private String m_mime;
        private String m_disposition;

        public FileInfo(String pw, File source, String mime, String disp) {
            this.m_pw = pw;
            this.m_source = source;
            this.m_mime = mime;
            this.m_disposition = disp;
        }

        public String getDisposition() {
            return this.m_disposition;
        }

        public String getPw() {
            return this.m_pw;
        }

        public File getSource() {
            return this.m_source;
        }

        public String getMime() {
            return this.m_mime;
        }
    }
}

