/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import to.etc.domui.server.ConfigParameters;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.HttpServerRequestResponse;
import to.etc.domui.server.IContextMaker;
import to.etc.domui.server.IFilterRequestHandler;
import to.etc.domui.server.IRequestInterceptor;
import to.etc.domui.server.RequestContextImpl;
import to.etc.domui.server.WrappedHttpServetResponse;
import to.etc.domui.state.UIContext;
import to.etc.net.HttpCallException;
import to.etc.webapp.nls.NlsContext;

public abstract class AbstractContextMaker
implements IContextMaker {
    private static final String LOCALE_PARAM = "___locale";
    private List<Pair> m_ieEmulationList = new ArrayList<Pair>();

    @Override
    public abstract void handleRequest(@Nonnull HttpServletRequest var1, @Nonnull HttpServletResponse var2, @Nonnull FilterChain var3) throws Exception;

    public AbstractContextMaker(ConfigParameters pp) throws UnavailableException {
        this.decodeParameters(pp);
    }

    private void decodeParameters(ConfigParameters pp) throws UnavailableException {
        String emu = pp.getString("ie-emulation");
        if (emu != null) {
            String[] patar;
            for (String patmode : patar = emu.split("\\s")) {
                Pattern par;
                if ((patmode = patmode.trim()).length() == 0) continue;
                int pos = patmode.lastIndexOf(58);
                if (pos == -1) {
                    throw new UnavailableException("Missing ':' in ie-emulation parameter in web.xml");
                }
                String pat = patmode.substring(0, pos);
                try {
                    par = Pattern.compile(pat);
                }
                catch (Exception x) {
                    throw new IllegalArgumentException("Invalid pattern '" + pat + "' in web.xml ie-emulation: " + x);
                }
                String xv = patmode.substring(pos + 1).trim();
                if (xv.length() == 0) continue;
                this.m_ieEmulationList.add(new Pair(par, xv));
            }
        }
    }

    private Locale decodeLocale(@Nonnull HttpServerRequestResponse rr, @Nonnull RequestContextImpl ctx) throws Exception {
        Locale loc;
        String[] args;
        String forceloc = rr.getParameter(LOCALE_PARAM);
        if (null != forceloc && (args = forceloc.split("_")).length >= 1) {
            String lang = args[0];
            String country = args.length >= 2 ? args[1] : lang.toUpperCase();
            Locale loc2 = new Locale(lang, country);
            rr.getRequest().getSession().setAttribute(LOCALE_PARAM, (Object)loc2);
            return loc2;
        }
        HttpSession ses = rr.getRequest().getSession(false);
        if (null != ses && null != (loc = (Locale)ses.getAttribute(LOCALE_PARAM))) {
            return loc;
        }
        return ctx.getApplication().getRequestLocale(rr.getRequest());
    }

    public void execute(@Nonnull HttpServerRequestResponse requestResponse, @Nonnull RequestContextImpl ctx, FilterChain chain) throws Exception {
        Locale loc = this.decodeLocale(requestResponse, ctx);
        NlsContext.setLocale((Locale)loc);
        List<IRequestInterceptor> il = ctx.getApplication().getInterceptorList();
        Exception xx = null;
        IFilterRequestHandler rh = null;
        try {
            UIContext.internalSet(ctx);
            AbstractContextMaker.callInterceptorsBegin(il, ctx);
            rh = ctx.getApplication().findRequestHandler(ctx);
            if (rh == null) {
                this.handleDoFilter(chain, requestResponse.getRequest(), requestResponse.getResponse());
                return;
            }
            requestResponse.getResponse().addHeader("X-UA-Compatible", "IE=edge");
            requestResponse.getResponse().addHeader("X-XSS-Protection", "0");
            rh.handleRequest(ctx);
            ctx.flush();
        }
        catch (HttpCallException x) {
            requestResponse.getResponse().sendError(x.getCode(), x.getMessage());
        }
        catch (Exception xxx) {
            xx = xxx;
            throw xxx;
        }
        finally {
            AbstractContextMaker.callInterceptorsAfter(il, ctx, xx);
            ctx.internalOnRequestFinished();
            try {
                ctx.discard();
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            UIContext.internalClear();
        }
    }

    private void handleDoFilter(@Nonnull FilterChain chain, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) throws ServletException, IOException {
        if (this.m_ieEmulationList.size() == 0) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String xv = null;
        String url = request.getRequestURI();
        for (Pair p : this.m_ieEmulationList) {
            if (!p.matches(url)) continue;
            xv = p.getVersion();
            break;
        }
        if (xv == null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        WrappedHttpServetResponse wsr = new WrappedHttpServetResponse(url, response, xv);
        chain.doFilter((ServletRequest)request, (ServletResponse)wsr);
        wsr.flushBuffer();
    }

    public static void callInterceptorsBegin(List<IRequestInterceptor> il, RequestContextImpl ctx) throws Exception {
        for (int i = 0; i < il.size(); ++i) {
            IRequestInterceptor ri = il.get(i);
            try {
                ri.before(ctx);
                continue;
            }
            catch (Exception x) {
                DomApplication.LOG.error("Exception in RequestInterceptor.before()", (Throwable)x);
                while (--i >= 0) {
                    ri = il.get(i);
                    try {
                        ri.after(ctx, x);
                    }
                    catch (Exception xx) {
                        DomApplication.LOG.error("Exception in RequestInterceptor.after() in wrapup", (Throwable)xx);
                    }
                }
                throw x;
            }
        }
    }

    public static void callInterceptorsAfter(List<IRequestInterceptor> il, RequestContextImpl ctx, Exception x) throws Exception {
        Exception endx = null;
        int i = il.size();
        while (--i >= 0) {
            IRequestInterceptor ri = il.get(i);
            try {
                ri.after(ctx, x);
            }
            catch (Exception xx) {
                if (endx == null) {
                    endx = xx;
                }
                DomApplication.LOG.error("Exception in RequestInterceptor.after()", (Throwable)xx);
            }
        }
        if (endx != null) {
            throw endx;
        }
    }

    private static class Pair {
        @Nonnull
        private final Pattern m_pattern;
        @Nonnull
        private final String m_version;

        public Pair(@Nonnull Pattern pattern, @Nonnull String version) {
            this.m_pattern = pattern;
            this.m_version = version;
        }

        public boolean matches(@Nonnull String url) {
            return this.m_pattern.matcher(url).matches();
        }

        @Nonnull
        public String getVersion() {
            return this.m_version;
        }
    }
}

