/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.server;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import to.etc.domui.server.ConfigParameters;
import to.etc.domui.server.DefaultLoginDeterminator;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.FilterConfigParameters;
import to.etc.domui.server.IContextMaker;
import to.etc.domui.server.ILoginDeterminator;
import to.etc.domui.server.IRequestResponseWrapper;
import to.etc.domui.server.NormalContextMaker;
import to.etc.domui.server.ReloadingContextMaker;
import to.etc.domui.server.ServerClientRegistry;
import to.etc.domui.util.DomUtil;
import to.etc.log.EtcLoggerFactory;
import to.etc.net.NetTools;
import to.etc.util.ClassUtil;
import to.etc.util.DeveloperOptions;
import to.etc.util.FileTool;
import to.etc.util.StringTool;
import to.etc.util.WrappedException;

public class AppFilter
implements Filter {
    static final Logger LOG = LoggerFactory.getLogger(AppFilter.class);
    private ConfigParameters m_config;
    private String m_applicationClassName;
    private boolean m_logRequest;
    private static String m_appContext;
    @Nullable
    private static IRequestResponseWrapper m_ioWrapper;
    private IContextMaker m_contextMaker;
    private ServerClientRegistry m_clientRegistry;
    private ILoginDeterminator m_loginDeterminator;

    public static synchronized void setIoWrapper(@Nonnull IRequestResponseWrapper ww) {
        m_ioWrapper = ww;
    }

    public void destroy() {
        if (DomApplication.get() != null) {
            DomApplication.get().internalDestroy();
        }
    }

    public static String minitime() {
        Calendar cal = Calendar.getInstance();
        return cal.get(11) + StringTool.intToStr((int)cal.get(12), (int)10, (int)2) + StringTool.intToStr((int)cal.get(13), (int)10, (int)2) + "." + cal.get(14);
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        try {
            String userid;
            HttpServletRequest rq = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)res;
            IRequestResponseWrapper ww = m_ioWrapper;
            if (null != ww) {
                rq = ww.getWrappedRequest(rq);
                response = ww.getWrappedResponse(response);
            }
            if (null != (userid = this.m_loginDeterminator.getLoginData(rq))) {
                this.m_clientRegistry.registerRequest(rq, userid);
            }
            MDC.put((String)"session", (String)rq.getSession().getId());
            MDC.put((String)"loginId", (String)userid);
            rq.setCharacterEncoding("UTF-8");
            if (this.m_logRequest) {
                String rs = rq.getQueryString();
                rs = rs == null ? "" : "?" + rs;
                System.out.println(AppFilter.minitime() + " rq=" + rq.getRequestURI() + rs);
            }
            AppFilter.initContext(req);
            this.m_contextMaker.handleRequest(rq, (HttpServletResponse)res, chain);
        }
        catch (RuntimeException x) {
            DomUtil.dumpExceptionIfSevere(x);
            throw x;
        }
        catch (ServletException x) {
            DomUtil.dumpExceptionIfSevere((Exception)((Object)x));
            throw x;
        }
        catch (IOException x) {
            if (x.getClass().getName().endsWith("ClientAbortException")) {
                throw x;
            }
            DomUtil.dumpExceptionIfSevere(x);
            throw x;
        }
        catch (Exception x) {
            DomUtil.dumpExceptionIfSevere(x);
            throw new WrappedException((Throwable)x);
        }
        catch (Error x) {
            x.printStackTrace();
            throw x;
        }
    }

    private static synchronized void initContext(ServletRequest req) {
        if (m_appContext != null || !(req instanceof HttpServletRequest)) {
            return;
        }
        m_appContext = NetTools.getApplicationContext((HttpServletRequest)((HttpServletRequest)req));
    }

    public static synchronized String internalGetWebappContext() {
        return m_appContext;
    }

    @Nullable
    private static String readDefaultConfiguration(@Nullable String logConfigLocation) {
        if (logConfigLocation != null) {
            try {
                File configFile = new File(logConfigLocation);
                if (!configFile.exists() || !configFile.isFile()) {
                    String res;
                    if (!logConfigLocation.startsWith("/") && (res = FileTool.readResourceAsString(AppFilter.class, (String)("/" + logConfigLocation), (String)"utf-8")) != null) {
                        System.out.println("DomUI: using user-specified log config file from classpath-resource " + logConfigLocation);
                        return res;
                    }
                } else {
                    String res = FileTool.readFileAsString((File)configFile, (String)"utf-8");
                    if (res != null) {
                        System.out.println("DomUI: using logging configuration file " + configFile.getAbsolutePath());
                        return res;
                    }
                }
            }
            catch (Exception configFile) {
                // empty catch block
            }
        }
        try {
            String res = FileTool.readResourceAsString(AppFilter.class, (String)"etcLoggerConfig.xml", (String)"utf-8");
            if (res != null) {
                System.out.println("DomUI: using internal etcLoggerConfig.xml");
            }
            return res;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public synchronized void init(FilterConfig config) throws ServletException {
        File approot = new File(config.getServletContext().getRealPath("/"));
        File logConfigLocation = new File(approot, "Private" + File.separator + "etcLog");
        AppFilter.initLogConfig(logConfigLocation, config.getInitParameter("logpath"));
        try {
            this.m_logRequest = DeveloperOptions.getBool((String)"domui.logurl", (boolean)false);
            System.out.println("WebApp root=" + approot);
            if (!approot.exists() || !approot.isDirectory()) {
                throw new IllegalStateException("Internal: cannot get webapp root directory");
            }
            this.m_config = new FilterConfigParameters(config, approot);
            this.m_applicationClassName = this.getApplicationClassName(this.m_config);
            if (this.m_applicationClassName == null) {
                throw new UnavailableException("The application class name is not set. Use 'application' in the Filter parameters to set a main class.");
            }
            String s = config.getInitParameter("login-determinator");
            this.m_loginDeterminator = null != s ? (ILoginDeterminator)ClassUtil.loadInstance((ClassLoader)this.getClass().getClassLoader(), ILoginDeterminator.class, (String)s) : new DefaultLoginDeterminator();
            this.m_clientRegistry = ServerClientRegistry.getInstance();
            String domUiReload = DeveloperOptions.getString((String)"domui.reload");
            String autoload = domUiReload != null ? domUiReload : this.m_config.getString("auto-reload");
            String autoloadWatchOnly = this.m_config.getString("auto-reload-watch-only");
            this.m_contextMaker = DeveloperOptions.isDeveloperWorkstation() && DeveloperOptions.getBool((String)"domui.developer", (boolean)true) && autoload != null && autoload.trim().length() > 0 ? new ReloadingContextMaker(this.m_applicationClassName, this.m_config, autoload, autoloadWatchOnly) : new NormalContextMaker(this.m_applicationClassName, this.m_config);
        }
        catch (RuntimeException x) {
            DomUtil.dumpException(x);
            throw x;
        }
        catch (ServletException x) {
            DomUtil.dumpException((Exception)((Object)x));
            throw x;
        }
        catch (Exception x) {
            DomUtil.dumpException(x);
            throw new RuntimeException(x);
        }
        catch (Error x) {
            x.printStackTrace();
            throw x;
        }
    }

    public static void initLogConfig(@Nullable File writableConfigLocation, @Nullable String logConfig) throws Error {
        try {
            if (null == writableConfigLocation) {
                File f = FileTool.getTmpDir();
                writableConfigLocation = new File(f, "etclogger.config");
            }
            writableConfigLocation.mkdirs();
            String xmlContent = null;
            if (writableConfigLocation.exists() && writableConfigLocation.isFile()) {
                try {
                    xmlContent = FileTool.readFileAsString((File)writableConfigLocation);
                }
                catch (Exception x) {
                    System.err.println("etclog: failed to read " + writableConfigLocation);
                }
            }
            if (null == xmlContent) {
                String logspec = DeveloperOptions.getString((String)"domui.logconfig");
                if (logspec == null && null == (logspec = System.getProperty("domui.logconfig"))) {
                    logspec = logConfig;
                }
                if (null == (xmlContent = AppFilter.readDefaultConfiguration(logspec))) {
                    throw new IllegalStateException("no logger configuration found at all");
                }
            }
            EtcLoggerFactory.getSingleton().initialize(writableConfigLocation, xmlContent);
        }
        catch (Exception x) {
            x.printStackTrace();
            throw WrappedException.wrap((Exception)x);
        }
        catch (Error x) {
            x.printStackTrace();
            throw x;
        }
    }

    public String getApplicationClassName(ConfigParameters p) {
        return p.getString("application");
    }
}

